<?php
/*
* Schedule a job
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/other_functions.php');



function wtg_schedule_job_list() {
	wtg_db_check_and_create();
	wtg_messages();
	?>
	<div class="wrap">
		<h2>Schedule Job List</h2>
		<table class="widefat">
		<thead>
		<tr>
			<th>Post Title</th>
			<th>Feed</th>
			<th>Aggregator Site</th>
		</tr>
		</thead>
		<tbody>
    <?php
    $db = new WTG_DB();
    $jobs = $db->get_all_job();
    $domain_url=wtg_domain_name();
    $wtg_option = get_option('wtg_option');
    if (!empty($jobs)) {
        $class = '';
        $previous_post_id='';
        
        foreach ($jobs as $job) {
            $class = ($class == 'class="alternate"') ? '' : 'class="alternate"';
	?>
		<tr <?php echo $class; ?>>
			<td>
	<?php 
			if($job->post_id != $previous_post_id) {
				$postlnk = get_permalink($job->post_id);
				$post = get_post($job->post_id); 
				echo '<a href="'.$postlnk.'" target="_blank">'.htmlspecialchars($post->post_title).'</a>';
			}
	?>
			</td>
			<td>
	<?php
			if($job->post_id != $previous_post_id) {
				$feedUrl=$domain_url.'/'.$wtg_option['feedDir'].'/' .$job->feed_name."\n";
				echo '<a href="'.$feedUrl.'" target="_blank">'.$job->feed_name.'</a>';
			}
	?>
            		</td>
			<td>
	<?php
			$ag = new WTG_Aggregator();
            		$ag->initDB();
            		$aggregator = $ag->get_aggregatorDB($job->aggregator_id);
           		echo $aggregator->name;
	?>
			</td>
		</tr>
    <?php
    		$previous_post_id=$job->post_id;
		}
    } else {
        echo '<tr><td colspan="5" align="center"><strong>No entries found</strong></td></tr>';
    }
    ?>
		</tbody>
		</table>
	</div>
<?php
}

function wtg_domain_name() {
	$u = @parse_url(get_option('siteurl'));
	return 'http://' . $u['host'] . ':' . (isset($u['port'])?$u['port']:80);
}