<?php
/*
* Custom feed (atom)
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/

function wtg_custom_feed_atom(){

	header('Content-Type: application/atom+xml; charset=' . get_option('blog_charset'), true);

	if ( have_posts()) {

		the_post();

	}

	else exit ;



	echo '<?xml version="1.0" encoding="'.get_option('blog_charset').'"?'.'>'; ?>

	

	<feed

	  xmlns="http://www.w3.org/2005/Atom"

	  xmlns:thr="http://purl.org/syndication/thread/1.0"

	  xml:lang="<?php echo get_option('rss_language'); ?>"

	  xml:base="<?php self_link(); ?>"

	 >

		<title type="text"><?php the_title_rss() ?></title>

		<updated><?php echo mysql2date('Y-m-d\TH:i:s\Z', get_lastpostmodified('GMT')); ?></updated>

		<?php the_generator( 'atom' ); ?>

		<link rel="alternate" type="text/html" href="<?php the_permalink_rss() ?>" />

		<id><?php self_link(); ?></id>

		<link rel="self" type="application/atom+xml" href="<?php self_link(); ?>" />

		<entry>

			<author>

				<name><?php the_author() ?></name>

				<?php $author_url = get_the_author_url(); if ( !empty($author_url) ) : ?>

				<uri><?php the_author_url()?></uri>

				<?php endif; ?>

			</author>

			<title type="<?php html_type_rss(); ?>"><![CDATA[<?php the_title_rss() ?>]]></title>

			<link rel="alternate" type="text/html" href="<?php the_permalink_rss() ?>" />

			<id><?php the_guid(); ?></id>

			<updated><?php echo get_post_modified_time('Y-m-d\TH:i:s\Z', true); ?></updated>

			<published><?php echo get_post_time('Y-m-d\TH:i:s\Z', true); ?></published>

			<?php the_category_rss('atom') ?>

			<summary type="<?php html_type_rss(); ?>"><![CDATA[<?php the_excerpt_rss(); ?>]]></summary>

	<?php if ( !get_option('rss_use_excerpt') ) : ?>

			<content type="<?php html_type_rss(); ?>" xml:base="<?php the_permalink_rss() ?>"><![CDATA[<?php the_content('', 0, '') ?>]]></content>

	<?php endif; ?>

	<?php atom_enclosure(); ?>

		</entry>

	</feed>

<?php

die();

}