<?php

  global $wp_version;
  global $wpdb;

  @set_time_limit(43200); # 12 hours

  $my_product = 'commentpig';

  $plugin_dir = basename(dirname(__FILE__)) . "/";
  $plugin_file = "commentpig.php";
  $plugin_name = $plugin_dir . $plugin_file;
  $plugin_url = get_option('siteurl') . "/wp-content/plugins/{$plugin_dir}";
  $config_url = "?page={$plugin_name}";
  $my_version = 'unknown';
  $plugins = get_plugins();
  if(is_array($plugins)) {
    $my_version = $plugins[$plugin_name]['Version'];
    $plugins_allowedtags = array('a' => array('href' => array(),'title' => array()),'abbr' => array('title' => array()),'acronym' => array('title' => array()),'code' => array(),'em' => array(),'strong' => array());
    $my_version = wp_kses($my_version, $plugins_allowedtags);
    unset($plugins_allowedtags);
  }
  $plugin_path = ABSPATH . "wp-content/plugins/" . $plugin_dir;

  $pro_link = "
    <A href=\"http://www.blogpig.com/api_key?type=commentpigpro\" title=\"Upgrade to CommentPiG PRO\" target=\"_blank\" >
      <IMG alt=\"pro\" src=\"{$plugin_url}images/pro_icon.png\" style=\"vertical-align:middle\" /></A>
    ";


  if (isset($_GET['s'])) {
    if($_GET['s'] == 'comments') {
      $list_title = 'Comments';
      $table = $wpdb->prefix . "comment_content";
      $fields = array('id', 'content', 'tags', 'used');
      $headers = array('ID', 'Comment', 'Tag', 'Used');
      $widths = array('10%', '80%', '10%');
    }
    else if ($_GET['s'] == 'users') {
      $list_title = 'Names';
      $table = $wpdb->prefix . "comment_users";
      $fields = array('id', 'name', 'used');
      $headers = array('ID', 'Name', 'Used');
      $widths = array('10%', '80%', '10%');
    }

    if(count($fields) > 0) {
      $start = $_GET['start'];
      if(!$start) {
        $start = 0;
      }
      $count = $_GET['count'];
      if(!$count) {
        $count = 25;
      }
      $order = $_GET['order'];
      if(!$order) {
        $order = 'id';
      }

      $selectSQL = "SELECT " . implode(',', $fields)  . " FROM $table ORDER BY $order LIMIT $start, $count ";
      #echo "selectSQL = `$selectSQL` <BR />";
      $rows = $wpdb->get_results($selectSQL);

      $output = '<TABLE border="0" width="100%">';

      $line = '<TR>';
      $cnt = 0;
      while($cnt < count($fields)) {
        $line .= "<TD width='" . $widths[$cnt] . "'>" . $headers[$cnt] . "</TD>";
        $cnt++;
      }
      $line .= '</TR>';
      $output .= $line;

      $eof = 0;
      foreach($rows as $row) {
        if($eof % 2 == 0) {
          $line = '<TR style="background:#EEEEEE; " >';
        }
        else {
          $line = '<TR style="background:#FFFFFF; " >';
        }
        foreach($fields as $field) {
          #echo "field = `$field` <BR />";
          #$echo "row[$field] = `" . $row->$field . "` <BR />";
          $line .= '<TD>' . $row->$field . '</TD>';
        }
        $line .= '</TR>';

        $output .= $line;
        $eof++;
      }
      if($eof < $count) {
        $eof = true;
      }
      else {
        $eof = false;
      }
      $output .= '</TABLE>';
    }

    $start_prev = $start - $count;
    if($start_prev < 0) {
      $start_prev = 0;
    }
    $start_next = $start;
    if(!$eof) {
      $start_next = $start + $count;
    }
    $settings_url = get_option('siteurl') . '/wp-admin/admin.php' . $config_url;
    $url_prev = $settings_url . "&s=" . $_GET['s'] . "&start=$start_prev&count=$count&";
    $url_next = $settings_url . "&s=" . $_GET['s'] . "&start=$start_next&count=$count&";

    ?>
      <div class="wrap">
        <div id="icon-plugins" class="icon32"><br /></div>
        <h2>CommentPiG</h2>

        <div id="poststuff" class="metabox-holder">
          <div id="post-body">
            <div id="post-body-content">
              <div id='normal-sortables' class='meta-box-sortables'>
                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default;'>
                    <span><?php echo $list_title; ?></span>
                  </h3>
                  <div class="inside">
                    <p>
                      <?php echo $output; ?>
                    </p>
                    <p><a href="<?php echo $url_prev; ?>">previous</a> :: <a href="<?php echo $url_next; ?>">next</a></p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <a href="<?php echo $settings_url; ?>"><input type="button" class="button" value="&laquo;  Go back" /></a>
      </div>

    <?php

  }
  else {

    ?>

    <?php

    if (isset($_REQUEST['runNow'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));
      if(function_exists('wpcommentpig_cron_run')) {
        ob_start();
        wpcommentpig_cron_run(false);
        $run_result = ob_get_contents();
        ob_end_clean();
        $run_message = "Triggered comment posting... (" . $run_result . ")";
        ?>
          <div id='message' class='updated fade' style='padding:4px;'><strong><?php _e($run_message) ?></strong></div>
        <?php
      }
    }

    if (isset($_POST['submit']) || isset($_POST['submitGeneral'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));

      $random_delay = $_POST['wpcommentpig_delay'];
      update_option('wpcommentpig_delay', $random_delay);
      # Schedule next run...
      if(function_exists('wpcommentpig_reschedule_cron')) {
        wpcommentpig_reschedule_cron();
      }

      $oldposts = $_POST['wpcommentpig_oldposts'];
      $oldpostsdelay = $_POST['wpcommentpig_oldpostsdelay'];
      update_option('wpcommentpig_oldposts', $oldposts);
      update_option('wpcommentpig_oldpostsdelay', $oldpostsdelay);

      $excludecats = $_POST['wpcommentpig_excludecats'];
      $excludecats_list = $_POST['wpcommentpig_excludecats_list'];
      if(is_array($excludecats_list)) {
        $excludecats_list = implode(",", $excludecats_list);
      }
      update_option('wpcommentpig_excludecats', $excludecats);
      update_option('wpcommentpig_excludecats_list', $excludecats_list);

      $target = $_POST['wpcommentpig_target'];
      $target_field = $_POST['wpcommentpig_target_field'];
      $target_minsize = $_POST['wpcommentpig_target_minsize'];
      update_option('wpcommentpig_target', $target);
      update_option('wpcommentpig_target_field', $target_field);
      update_option('wpcommentpig_target_minsize', $target_minsize);

      $status = $_POST['wpcommentpig_status'];
      update_option('wpcommentpig_status', $status);

      $retrycount = $_POST['wpcommentpig_retrycount'];
      update_option('wpcommentpig_retrycount', $retrycount);
    }

    if (isset($_POST['submit']) || isset($_POST['submitSources'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));

      if(is_array($_POST['wpcommentpig_source'])) {
        $source = implode(',', $_POST['wpcommentpig_source']);
      }
      else {
        $source = $_POST['wpcommentpig_source'];
      }
      update_option('wpcommentpig_source', $source);
      $yahoo_app_id = $_POST['wpcommentpig_yahoo_app_id'];
      update_option('wpcommentpig_yahoo_app_id', $yahoo_app_id);
      $reusecomments = $_POST['wpcommentpig_reusecomments'];
      update_option('wpcommentpig_reusecomments', $reusecomments);

      $weight_youtube = $_POST['wpcommentpig_weight_youtube'];
      update_option('wpcommentpig_weight_youtube', $weight_youtube);
      $weight_youtube2 = $_POST['wpcommentpig_weight_youtube2'];
      update_option('wpcommentpig_weight_youtube2', $weight_youtube2);
      $weight_twitter = $_POST['wpcommentpig_weight_twitter'];
      update_option('wpcommentpig_weight_twitter', $weight_twitter);
      $weight_backtype = $_POST['wpcommentpig_weight_backtype'];
      update_option('wpcommentpig_weight_backtype', $weight_backtype);
      $weight_friendfeed = $_POST['wpcommentpig_weight_friendfeed'];
      update_option('wpcommentpig_weight_friendfeed', $weight_friendfeed);
      $weight_yahooanswers = $_POST['wpcommentpig_weight_yahooanswers'];
      update_option('wpcommentpig_weight_yahooanswers', $weight_yahooanswers);
      $weight_wordpress = $_POST['wpcommentpig_weight_wordpress'];
      update_option('wpcommentpig_weight_wordpress', $weight_wordpress);
      $weight_localdb = $_POST['wpcommentpig_weight_localdb'];
      update_option('wpcommentpig_weight_localdb', $weight_localdb);

      if(is_array($_POST['wpcommentpig_username_source'])) {
        $username_source = implode(',', $_POST['wpcommentpig_username_source']);
      }
      else {
        $username_source = $_POST['wpcommentpig_username_source'];
      }
      update_option('wpcommentpig_username_source', $username_source);
    }

    if (isset($_POST['submit']) || isset($_POST['submitFilters'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));

      $keywordexists = $_POST['wpcommentpig_keywordexists'];
      update_option('wpcommentpig_keywordexists', $keywordexists);

      $commentsizemin = $_POST['wpcommentpig_commentsizemin'];
      $commentsizemax = $_POST['wpcommentpig_commentsizemax'];
      $longcomments = $_POST['wpcommentpig_longcomments'];
      update_option('wpcommentpig_commentsizemin', $commentsizemin);
      update_option('wpcommentpig_commentsizemax', $commentsizemax);
      update_option('wpcommentpig_longcomments', $longcomments);

      $badwords = $_POST['wpcommentpig_badwords'];
      $badwords_list = $_POST['wpcommentpig_badwords_list'];
      update_option('wpcommentpig_badwords', $badwords);
      update_option('wpcommentpig_badwords_list', $badwords_list);

      $badaccounts = $_POST['wpcommentpig_badaccounts'];
      $badaccounts_list = $_POST['wpcommentpig_badaccounts_list'];
      update_option('wpcommentpig_badaccounts', $badaccounts);
      update_option('wpcommentpig_badaccounts_list', $badaccounts_list);

      $striplinks = $_POST['wpcommentpig_striplinks'];
      update_option('wpcommentpig_striplinks', $striplinks);
    }

    if (isset($_POST['clearComments'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));
      $table = $wpdb->prefix . "comment_content";
      $truncateSQL = "TRUNCATE TABLE $table ";
      $wpdb->query($truncateSQL);
    }

    if (isset($_REQUEST['resetUsedComments'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));
      $table = $wpdb->prefix . "comment_content";
      $truncateSQL = "UPDATE $table SET used = 0 ";
      $wpdb->query($truncateSQL);
    }

    if (isset($_POST['submit']) || isset($_POST['submitComments'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));

      $tmp_name = $_FILES['wpcommentpig_comments_upload']['tmp_name'];
      $name = $_FILES['wpcommentpig_comments_upload']['name'];
      #echo "DEBUG:: tmp_name = `{$tmp_name}` <BR /> \n";
      #echo "DEBUG:: name = `{$name}` <BR /> \n";
      if(file_exists($tmp_name)) {
        $random_comments = false;

        if(preg_match('/\.zip$/i', $name)) {
          require_once dirname(__FILE__)."/dUnzip2.inc.php";
          $zip = new dUnzip2($tmp_name);
          $zip->getList();
          $random_comments = '';
          foreach($zip->compressedList as $file_name => $file_info) {
            $file_text = $zip->unzip($file_name);
            #echo "DEBUG:: File text for `{$file_name}`: `{$file_text}` <BR />\n";
            $random_comments .= $file_text . "\n";
          }
          $cmp_name = false;
        }
        else {
          $cmp_name = $tmp_name;
        }

        #echo "DEBUG:: cmp_name = `{$cmp_name}` <BR /> \n";
        if(file_exists($cmp_name) || $random_comments) {
          if(!$random_comments) {
            $random_comments = file_get_contents($cmp_name);
          }
          $random_comments = preg_replace('/\r\n/', "\n", $random_comments);
          update_option('wpcommentpig_comments', '');
          $table = $wpdb->prefix . "comment_content";
          $insertSQL = "INSERT INTO $table (content, tags) VALUES ";
          $my_comments = preg_split('/\n/', $random_comments);
          $cnt = 0;
          $first = true;

          $header = false;
          $delimiters = array(',', ';', '|');
          $delimiter = ',';
          $enclosure = '"';
          $del_found = false;

          while($cnt < count($my_comments)) {
            $item = trim($my_comments[$cnt]);
            if($item && $item != '') {
              # detect the delimiter...
              if(!$header) {
                $del_cnt = 0;
                while(!$del_found && $del_cnt < count($delimiters)) {
                  if(strpos($item, $delimiters[$del_cnt]) !== false) {
                    $delimiter = $delimiters[$del_cnt];
                    $del_found = true;
                  }
                  $del_cnt++;
                }
                $header = explode($delimiter, strtolower($line));
              }
              else {
                # parse the line and get the data into the temp table...
                #$parts = explode($delimiter, $item);
                $tmp = explode($delimiter, rtrim($item));

                $in_quote = false;
                $parts = array();
                foreach($tmp as $key => $value) {
                  if($in_quote) {
                    if(wpcommentpig_has_quote($value, $enclosure) ) {
                      $in_quote = false;
                      $value = substr_replace($value, '', -1, 1);
                    }
                    $key = (count($parts) - 1);
                    $parts[$key] .= $delimiter . $value;
                  }
                  else {
                    if(wpcommentpig_has_quote($value, $enclosure)) {
                      $in_quote = true;
                      $value = substr_replace($value, '', 0, 1);
                    }
                    else if(substr($value, 0, 1) == $enclosure AND substr($value, -1, 1) == $enclosure) {
                      $value = substr_replace($value, '', 0, 1);
                      $value = substr_replace($value, '', -1, 1);
                    }
                    $parts[] = $value;
                  }
                }
                unset($tmp);
                #echo "parts = `" . print_r($parts, true) . "` <BR />\n";

                if(!$first > 0) {
                  $insertSQL .= ", ";
                }
                $insertSQL .= " ('" . addslashes(trim($parts[0], '"')) . "', '" . addslashes(trim($parts[1], '"')) . "') ";
                $first = false;
              }
            }

            # Do it in batches of 100 items...
            if(($cnt > 0 && $cnt % 100 == 0) || ($cnt == count($my_comments) - 1)) {
              $wpdb->query($insertSQL);
              $insertSQL = "INSERT INTO $table (content, tags) VALUES ";
              $first = true;
            }

            $cnt++;
          }
          $wpdb->query($insertSQL);

          unset($delimiters);
          unset($header);
        }
      }
    }

    if (isset($_POST['clearUsers'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));
      $table = $wpdb->prefix . "comment_users";
      $truncateSQL = "TRUNCATE TABLE $table ";
      $wpdb->query($truncateSQL);
    }

    if (isset($_REQUEST['resetUsedUsers'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));
      $table = $wpdb->prefix . "comment_users";
      $truncateSQL = "UPDATE $table SET used = 0 ";
      $wpdb->query($truncateSQL);
    }

    if (isset($_POST['submit']) || isset($_POST['submitUsers'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));

      $tmp_name = $_FILES['wpcommentpig_users_upload']['tmp_name'];
      $name = $_FILES['wpcommentpig_users_upload']['name'];
      #echo "DEBUG:: tmp_name = `{$tmp_name}` <BR /> \n";
      #echo "DEBUG:: name = `{$name}` <BR /> \n";
      if(file_exists($tmp_name)) {
        $random_users = false;

        if(preg_match('/\.zip$/i', $name)) {
          require_once dirname(__FILE__)."/dUnzip2.inc.php";
          $zip = new dUnzip2($tmp_name);
          $zip->getList();
          #$zip->unzipAll('uncompressed');
          #print_r($zip->compressedList);
          $random_users = '';
          foreach($zip->compressedList as $file_name => $file_info) {
            $file_text = $zip->unzip($file_name);
            #echo "DEBUG:: File text for `{$file_name}`: `{$file_text}` <BR />\n";
            $random_users .= $file_text . "\n";
          }
          $cmp_name = false;
        }
        else {
          $cmp_name = $tmp_name;
        }

        #echo "DEBUG:: cmp_name = `{$cmp_name}` <BR /> \n";
        if(file_exists($cmp_name) || $random_users) {
          if(!$random_users) {
            $random_users = file_get_contents($cmp_name);
          }
          $random_users = preg_replace('/\r\n/', "\n", $random_users);
          update_option('wpcommentpig_users', '');
          $table = $wpdb->prefix . "comment_users";
          $insertSQL = "INSERT INTO $table (name) VALUES ";
          $my_users = preg_split('/\n/', $random_users);
          $cnt = 0;
          $first = true;
          while($cnt < count($my_users)) {
            $item = addslashes(trim($my_users[$cnt]));
            if($item && $item != '') {
              if(!$first > 0) {
                $insertSQL .= ", ";
              }
              $insertSQL .= " ('" . $item . "') ";
              $first = false;
            }

            # Do it in batches of 100 items...
            if(($cnt > 0 && $cnt % 100 == 0) || ($cnt == count($my_users) - 1)) {
              $wpdb->query($insertSQL);
              $insertSQL = "INSERT INTO $table (name) VALUES ";
              $first = true;
            }

            $cnt++;
          }
          $wpdb->query($insertSQL);
        }
      }
    }

    if (isset($_POST['submit']) || isset($_POST['submitLinks'])) {
      if (function_exists('current_user_can') && !current_user_can('manage_options'))
        die(__('What are you doing here?!'));

      $userlinkrate = $_POST['wpcommentpig_userlinkrate'];
      update_option('wpcommentpig_userlinkrate', $userlinkrate);
      if(is_array($_POST['wpcommentpig_userlinktype'])) {
        $userlinktype = implode(',', $_POST['wpcommentpig_userlinktype']);
      }
      else {
        $userlinktype = $_POST['wpcommentpig_userlinktype'];
      }
      update_option('wpcommentpig_userlinktype', $userlinktype);
      $userlinkrelnofollow = $_POST['wpcommentpig_userlinkrelnofollow'];
      update_option('wpcommentpig_userlinkrelnofollow', $userlinkrelnofollow);

      $ownlinkrate = $_POST['wpcommentpig_ownlinkrate'];
      update_option('wpcommentpig_ownlinkrate', $ownlinkrate);
      $ownlinks = $_POST['wpcommentpig_ownlinks'];
      update_option('wpcommentpig_ownlinks', $ownlinks);
      $ownlinkrelnofollow = $_POST['wpcommentpig_ownlinkrelnofollow'];
      update_option('wpcommentpig_ownlinkrelnofollow', $ownlinkrelnofollow);
    }

    $table = $wpdb->prefix . "comment_content";
    $countSQL = "SELECT COUNT(*) FROM $table ";
    $comments_count = $wpdb->get_var($countSQL);
    $countSQL = "SELECT COUNT(*) FROM $table WHERE used > 0 ";
    $comments_used = $wpdb->get_var($countSQL);

    $table = $wpdb->prefix . "comment_users";
    $countSQL = "SELECT COUNT(*) FROM $table ";
    $users_count = $wpdb->get_var($countSQL);
    $countSQL = "SELECT COUNT(*) FROM $table WHERE used > 0 ";
    $users_used = $wpdb->get_var($countSQL);

    $local_random_delay = get_option('wpcommentpig_delay');
    $local_random_comments = ''; # get_option('wpcommentpig_comments');
    $local_random_users = ''; # get_option('wpcommentpig_users');

    $local_oldposts = get_option('wpcommentpig_oldposts');
    $local_oldpostsdelay = get_option('wpcommentpig_oldpostsdelay');
  #  if(!$local_oldpostsdelay || $local_oldpostsdelay == '') {
  #    $local_oldpostsdelay = '10';
  #    update_option('wpcommentpig_oldpostsdelay', $local_oldpostsdelay);
  #  }
    $local_excludecats = get_option('wpcommentpig_excludecats');
    $local_excludecats_list = get_option('wpcommentpig_excludecats_list');
    $local_reusecomments = get_option('wpcommentpig_reusecomments');
    if($local_oldposts == 'on') {
      $local_oldposts_text = 'checked';
    }
    else {
      $local_oldposts_text = '';
    }
    if($local_excludecats == 'on') {
      $local_excludecats_text = 'checked';
    }
    else {
      $local_excludecats_text = '';
    }
    if($local_reusecomments == 'on') {
      $local_reusecomments_text = 'checked';
    }
    else {
      $local_reusecomments_text = '';
    }

    $last_run = get_option('wpcommentpig_lastrun');
    if($last_run) {
      $last_run_caption = date('F d, Y \a\t H:i', $last_run);
    }
    else {
      $last_run_caption = 'never';
    }

    $next_run = wp_next_scheduled('wpcommentpig_cron_run_hook');
    #echo "DEBUG:: config - next_run(scheduled) = `" . print_r($next_run, true) . "` ";
    if($next_run) {
      $next_run_caption = date('F d, Y \a\t H:i', $next_run);
    }
    else {
      if(function_exists('wpcommentpig_reschedule_cron')) {
        wpcommentpig_reschedule_cron();
      }
      $next_run = wp_next_scheduled('wpcommentpig_cron_run_hook');
      $next_run_caption = date('F d, Y \a\t H:i', $next_run);
      #$next_run_caption = 'never';
    }

    $local_target = get_option('wpcommentpig_target');
    if(empty($local_target) || ($local_target == '')) {
      $local_target = 'random';
    }
    $local_target_field = get_option('wpcommentpig_target_field');
    $local_target_minsize = get_option('wpcommentpig_target_minsize', 2);
    $local_status = get_option('wpcommentpig_status');

    $local_retrycount = get_option('wpcommentpig_retrycount', 0);

    $local_source = get_option('wpcommentpig_source');
    if(empty($local_source) || ($local_source == '')) {
      $local_source = 'localdb';
    }
    $local_source_array = explode(',', $local_source);

    $local_weight_youtube = get_option('wpcommentpig_weight_youtube', 1);
    $local_weight_youtube2 = get_option('wpcommentpig_weight_youtube2', 1);
    $local_weight_twitter = get_option('wpcommentpig_weight_twitter', 1);
    $local_weight_backtype = get_option('wpcommentpig_weight_backtype', 1);
    $local_weight_friendfeed = get_option('wpcommentpig_weight_friendfeed', 1);
    $local_weight_yahooanswers = get_option('wpcommentpig_weight_yahooanswers', 1);
    $local_weight_wordpress = get_option('wpcommentpig_weight_wordpress', 1);
    $local_weight_localdb = get_option('wpcommentpig_weight_localdb', 1);

    $local_username_source = get_option('wpcommentpig_username_source');
    if(empty($local_username_source) || ($local_username_source == '')) {
      $local_username_source = 'localdb';
    }
    $local_username_source_array = explode(',', $local_username_source);

    $local_yahoo_app_id = get_option('wpcommentpig_yahoo_app_id');
    if(empty($local_yahoo_app_id) || ($local_yahoo_app_id == '')) {
      $local_yahoo_app_id = 'YahooDemo';
    }

    $local_keywordexists = get_option('wpcommentpig_keywordexists');
    if($local_keywordexists == 'on') {
      $local_keywordexists_text = 'checked';
    }
    else {
      $local_keywordexists_text = '';
    }
    $local_commentsizemin = get_option('wpcommentpig_commentsizemin');
    $local_commentsizemax = get_option('wpcommentpig_commentsizemax');
    $local_longcomments = get_option('wpcommentpig_longcomments');

    $local_badwords = get_option('wpcommentpig_badwords');
    if(empty($local_badwords) || ($local_badwords == '')) {
      $local_badwords = 'off';
    }
    $local_badwords_list = get_option('wpcommentpig_badwords_list');

    $local_badaccounts = get_option('wpcommentpig_badaccounts');
    if(empty($local_badaccounts) || ($local_badaccounts == '')) {
      $local_badaccounts = 'off';
    }
    $local_badaccounts_list = get_option('wpcommentpig_badaccounts_list');
    $local_striplinks = get_option('wpcommentpig_striplinks');
    if($local_striplinks == 'on') {
      $local_striplinks_text = 'checked';
    }
    else {
      $local_striplinks_text = '';
    }

    $local_userlinkrate = get_option('wpcommentpig_userlinkrate');
    $local_userlinktype = get_option('wpcommentpig_userlinktype');
    if(empty($local_userlinktype) || ($local_userlinktype == '')) {
      $local_userlinktype = 'random';
    }
    $local_userlinktype_array = explode(',', $local_userlinktype);
    $local_userlinkrelnofollow = get_option('wpcommentpig_userlinkrelnofollow');

    $local_ownlinkrate = get_option('wpcommentpig_ownlinkrate');
    $local_ownlinks = get_option('wpcommentpig_ownlinks');
    $local_ownlinkrelnofollow = get_option('wpcommentpig_ownlinkrelnofollow');


    $settings_url = get_option('siteurl') . '/wp-admin/admin.php' . $config_url;
    $view_all_comments_url = $settings_url . "&s=comments";
    $view_all_users_url = $settings_url . "&s=users";

    ?>
    <?php if ( !empty($_POST) ) : ?>
      <div id='message' class='updated fade' style='padding:4px;'><strong><?php _e(' Options saved.') ?></strong></div>
    <?php endif; ?>

    <?php
      if (isset($_POST['wpcommentpig_submit'])) {
        if (function_exists('current_user_can') && !current_user_can('manage_options'))
          die(__('What are you doing here?!'));

      }


      ?>
      <?php if ( !empty($_POST['wpcommentpig_submit'] ) ) : ?>
        <div id='message' class='updated fade' style='padding:4px;'><strong><?php _e(' Options saved.') ?></strong></div>
      <?php endif; ?>

    <div class="wrap">
      <div id="icon-plugins" class="icon32"><br /></div>
      <h2>CommentPiG</h2>

      <form action="<?php echo $config_url; ?>" method="post" id="wpcommentpig-conf" enctype="multipart/form-data">

        <div id="poststuff" class="metabox-holder has-right-sidebar">

          <div id="side-info-column" class="inner-sidebar">

            <div id='side-sortables' class='meta-box-sortables'>

              <?php
                if(!class_exists('WP_Http')) {
                  include_once(ABSPATH . WPINC. '/class-http.php');
                }
                $http = new WP_Http;
              ?>

              <div id="pagesubmitdiv" class="postbox " >
                <h3 class='hndle' style='cursor:default;'>
                  <span>Status</span>
                </h3>

                <div class="inside">

                  <div class="submitbox" id="submitpage">

                    <div id="minor-publishing">
                      <div id="misc-publishing-actions">

                        <div class="misc-pub-section misc-pub-section-first">
                          <img src="<?php echo $plugin_url . 'images/play.png'; ?>" />
                          <b><span id="post-comment-now-label"><a href="<?php bloginfo('wpurl'); echo '/wp-admin/admin-ajax.php'; ?>" onclick="post_comment_now(); return false;">Post Comment Now</a></span></b>
                          <span id="post-comment-now-status"></span>
                        </div>


                        <div class="misc-pub-section">
                          <label for="post_status">Your CommentPiG Version:</label>
                          <b><span id="post-status-display"><?php echo $my_version; ?></span></b>
                        </div>

                        <div class="misc-pub-section">
                          <label for="post_status">Current CommentPiG Version:</label>
                          <b><span id="post-status-display">
                          <?php
                            if($http) {
                              $reply = $http->request('http://www.blogpig.com/includes/version.php?p=' . $my_product);
                              echo ($reply && is_array($reply) ? $reply['body'] : '');
                            }
                          ?>
                          </span></b>
                        </div>

                        <div class="misc-pub-section">
                          <label for="post_status">Server Time:</label>
                          <b><span id="post-status-display"><?php echo date('F d, Y H:i'); ?></span></b>
                        </div>

                        <div class="misc-pub-section">
                          <label for="post_status">Last Run:</label>
                          <b><span id="post-status-display"><?php echo $last_run_caption; ?></span></b>
                        </div>

                        <div class="misc-pub-section">
                          <label for="post_status">Next Run:</label>
                          <b><span id="post-status-display"><?php echo $next_run_caption; ?></span></b>
                        </div>

                        <?php
                        commentpig_load_ioncube();
                        ?>
                        <div class="misc-pub-section misc-pub-section-last">
                          <label for="post_status">ionCube Loaders:</label>
                          <b><span id="post-status-display"><?php echo extension_loaded('ionCube Loader') ? "" : "Not"; ?> Found</span></b>
                          &nbsp; [ <a href="<?php echo get_option('siteurl') . "/wp-content/plugins/{$plugin_dir}ioncube/"; ?>">more info</a> ]
                        </div>


                      </div> <!--- id="misc-publishing-actions" --->
                    </div> <!--- id="minor-publishing" --->

                  </div> <!--- id="submitpage" --->

                </div> <!--- class="inside" --->
              </div> <!--- class="postbox " --->

              <div id="pageparentdiv" class="postbox " >
                <h3 class='hndle' style='cursor:default;'>
                  <span>BlogPiG Members</span>
                </h3>

                <div class="inside">
                  <p>
                    <ul>
                      <li><a href="http://blogpig.com/" target="_blank">BlogPiG Home</a></li>
                      <?php
                        if($http) {
                          $reply = $http->request('http://www.blogpig.com/includes/pages.php?xml=1');
                          if($reply && is_array($reply)) {
                            $pages = array();
                            $pages_count = preg_match_all('/<title>(.*?)<\/title>.*?<link>(.*?)<\/link>/is', $reply['body'], $pages);
                            if($pages_count > 0) {
                              $idx = 0;
                              while($idx < count($pages[0])) {
                                echo '<li><a href="' . $pages[2][$idx] . '" target="_blank">BlogPiG ' . $pages[1][$idx]. '</a></li>';
                                $idx++;
                              }
                            }
                          }

                        }
                      ?>
                    </ul>
                  </p>
                </div> <!--- class="inside" --->
              </div> <!--- class="postbox " --->

              <div id="pageparentdiv" class="postbox " >
                <h3 class='hndle' style='cursor:default;'>
                  <span>BlogPiG News</span>
                </h3>

                <div class="inside">
                  <p>
                    <ul>
                      <?php
                        if($http) {
                          $reply = $http->request('http://feeds.feedburner.com/blogpigcom');
                          if($reply && is_array($reply)) {
                            $news = array();
                            $news_count = preg_match_all('/<title>(.*?)<\/title>.*?<link>(.*?)<\/link>/is', $reply['body'], $news);
                            if($news_count > 1) {
                              $idx = 1;
                              while($idx < count($news[0])) {
                                echo '<li><a href="' . $news[2][$idx] . '" target="_blank">' . $news[1][$idx]. '</a></li>';
                                $idx++;
                              }
                            }
                          }

                        }
                      ?>
                    </ul>
                  </p>
                </div> <!--- class="inside" --->
              </div> <!--- class="postbox " --->

              <div id="pageparentdiv" class="postbox " >
                <h3 class='hndle' style='cursor:default;'>
                  <span>BlogPiG Software</span>
                </h3>
                <div class="inside">
                  <p>
                    <ul>
                      <?php
                        if($http) {
                          $reply = $http->request('http://blogpig.com/includes/products.php?xml=1');
                          if($reply && is_array($reply)) {
                            $products = array();
                            $products_count = preg_match_all('/<title>(.*?)<\/title>.*?<link>(.*?)<\/link>/is', $reply['body'], $products);
                            if($products_count > 0) {
                              $idx = 0;
                              while($idx < count($products[0])) {
                                echo '<li><a href="' . $products[2][$idx] . '" target="_blank">' . $products[1][$idx]. '</a></li>';
                                $idx++;
                              }
                            }
                          }

                        }
                      ?>
                    </ul>
                  </p>
                </div> <!--- class="inside" --->
              </div> <!--- class="postbox " --->

              <?php
                unset($http);
              ?>

            </div> <!---  class='meta-box-sortables' --->

          </div> <!--- class="inner-sidebar" --->


          <div id="post-body" class="has-sidebar">

            <div id="post-body-content" class="has-sidebar-content">

              <div id='normal-sortables' class='meta-box-sortables'>

                <!--- Tooltips --->
                <link type="text/css" media="screen" rel="stylesheet" href="<?php echo $plugin_url; ?>js/tooltips.css" />
                <!--- Colorboxes --->
                <link type="text/css" media="screen" rel="stylesheet" href="<?php echo $plugin_url; ?>js/colorbox.css" />
                <script type="text/javascript" src="<?php echo $plugin_url; ?>js/jquery.colorbox.js"></script>
                <script type="text/javascript">
                  jQuery(document).ready(function(){
                    jQuery(".colorboxtips").colorbox({innerWidth:"853px", innerHeight:"510px", iframe:true});
                  });
                </script>

                <!--- Adding new reg functions --->
                <?php commentpig_api_show_field($plugin_dir); ?>

                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default;'>
                    <span>Read Me</span>
                  </h3>
                  <div class="inside">
                    <p>
                      <TABLE width="100%" style="margin-top:12px;">
                        <TR valign="top">
                          <TD width="100%">
                            <P>
                              Congratulations on activating your CommentPiG plugin from BlogPiG.
                            </P>
                            <P>
                              <?php
                                if(!trim(get_option('blogpig_api_key'))) {
                                ?>
                                  Don't forget to enter your BlogPiG API Key in the box above. You can get it from your BlogPiG members area <a href="http://blogpig.com/members/">here</a>.
                                <?php
                                }
                                else if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) {
                                ?>
                                  The features marked with <?php echo $pro_link; ?> icons are only available to CommentPiG Pro license holders. You can instantly upgrade to a CommentPiG Pro license <a href="http://blogpig.com/products/commentpig">here</a>.
                                <?php
                                }
                                ?>
                            </P>
                            <P>
                              You can view a short tutorial video for each section by clicking on the <IMG src="<?php echo $plugin_url . '/images/camera.png'; ?>" style="vertical-align:middle; " />  icon.
                            </P>
                            <P>
                              You can also mouseover the <IMG src="<?php echo $plugin_url . '/images/tooltip.png'; ?>" style="vertical-align:middle; " /> icons for a short summary of each individual feature.
                            </P>
                            <P>
                              If you have any other questions just head on over to our help desk <a href="http://blogpig.com/help/">here</a> and we'll be more than happy to help.
                            </P>
                            <BR />
                          </TD>
                        </TR>
                      </TABLE>
                    </p>


                  </div>
                </div>

                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default; '>
                    <span style="vertical-align: top;">General</span><?php commentpig_show_header_link('commentpig-general', $plugin_dir); ?>
                  </h3>
                  <div class="inside">
                    <p>
                      <TABLE width="100%" style="margin-top:12px;">
                        <TR valign="top">
                          <TD width="30%">
                            Schedule: <?php commentpig_show_tooltip('schedule', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            Wait
                            <INPUT id="wpcommentpig_delay" name="wpcommentpig_delay" type="text" size="6" value="<?php echo $local_random_delay; ?>" />
                            minutes between comments
                            <BR />

                            <INPUT id="wpcommentpig_oldposts" name="wpcommentpig_oldposts" type="checkbox" <?php echo $local_oldposts_text; ?> value="on" />
                            <LABEL for="wpcommentpig_oldposts">
                              Don't comment on posts older than
                            </LABEL>
                            <INPUT id="wpcommentpig_oldpostsdelay" name="wpcommentpig_oldpostsdelay" type="text" size="4" value="<?php echo $local_oldpostsdelay; ?>" />
                            <LABEL for="wpcommentpig_oldpostsdelay">
                              days
                            </LABEL>
                            <BR />
                            <BR />
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="30%">
                            Category: <?php commentpig_show_tooltip('category', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT id="wpcommentpig_excludecats" name="wpcommentpig_excludecats" type="checkbox" <?php echo $local_excludecats_text; ?> value="on" />
                            <LABEL for="wpcommentpig_excludecats">
                              Don't comment on posts from these categories:
                            </LABEL>
                            <BR/>
                            <?php
                              if(function_exists('commentpig_pro_show_excludecats')) {
                                commentpig_pro_show_excludecats();
                              }
                            ?>
                            <BR />
                            <BR />
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="30%">
                            Target: <?php commentpig_show_tooltip('target', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT type="radio" id="wpcommentpig_target" name="wpcommentpig_target" value="tags" <?php if($local_target == 'tags') { echo "checked"; } ?> ></INPUT>
                            <LABEL>
                              post tags
                              (having no less than
                              <INPUT type="text" size="4" id="wpcommentpig_target_minsize" name="wpcommentpig_target_minsize" value="<?php echo $local_target_minsize; ?>" ></INPUT>
                              words)
                            </LABEL>
                            <BR />

                            <INPUT type="radio" id="wpcommentpig_target" name="wpcommentpig_target" value="title" <?php if($local_target == 'title') { echo "checked"; } ?> ></INPUT>
                            <LABEL>post title</LABEL>
                            <BR />

                            <INPUT type="radio" id="wpcommentpig_target" name="wpcommentpig_target" value="custom" <?php if($local_target == 'custom') { echo "checked"; } ?> ></INPUT>
                            <LABEL>post custom field:</LABEL>
                            <INPUT type="text" size="10" id="wpcommentpig_target_field" name="wpcommentpig_target_field" value="<?php echo $local_target_field; ?>" ></INPUT>
                            <BR />

                            <INPUT type="radio" id="wpcommentpig_target" name="wpcommentpig_target" value="random" <?php if($local_target == 'random') { echo "checked"; } ?> ></INPUT>
                            <LABEL>random (only for `Local DB` source)</LABEL>
                            <BR />

                            <P style="font-size:80%">
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>
                        <TR valign="top">
                          <TD width="30%">
                            Status: <?php commentpig_show_tooltip('status', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <SELECT id="wpcommentpig_status" name="wpcommentpig_status" style="margin-top: -2px;">
                              <OPTION value="approved" <?php if('approved' == $local_status) { echo "selected"; } ?>>Approved</OPTION>
                              <OPTION value="awaiting" <?php if('awaiting' == $local_status) { echo "selected"; } ?>>Awaiting Moderation</OPTION>
                            </SELECT>

                            <P style="font-size:80%">
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>
                        <TR valign="top">
                          <TD width="30%">
                            Retry: <?php commentpig_show_tooltip('retry', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT id="wpcommentpig_retrycount" name="wpcommentpig_retrycount" type="text" size="4" value="<?php echo $local_retrycount; ?>" />
                            times
                            <P style="font-size:80%">
                            </P>
                          </TD>
                        </TR>
                        <TR valign="top">
                          <TD width="100%" colspan="2" style="text-align:right; ">
                            <!---
                            <INPUT class="button" style="float:right; " type="submit" name="submitDelay" value="Update Delay &raquo;" />
                            <INPUT class="button"  style="float:right; " type="submit" name="submitTargets" value="Update Target   &raquo;" />
                            --->
                            <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="submitGeneral" value="Save &raquo;" />
                            <?php
                              if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) {
                                echo $pro_link;
                              }
                            ?>
                          </TD>
                        </TR>


                      </TABLE>
                    </p>


                  </div>
                </div>

                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default;'>
                    <span style="vertical-align: top;">Sources</span><?php commentpig_show_header_link('commentpig-sources', $plugin_dir); ?>
                  </h3>
                  <div class="inside">

                    <p>
                      <TABLE width="100%" style="margin-top:12px;">
                        <TR valign="top">
                          <TD width="30%">
                            Comments: <?php commentpig_show_tooltip('comments', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <TABLE width="100%" border="0">
                              <TR>
                                <TD>
                                  &nbsp;
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  weight
                                </TD>
                              </TR>
                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="youtube" <?php if(in_array('youtube', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>YouTube (video tags search)</LABEL>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_youtube" id="wpcommentpig_weight_youtube" value="<?php echo $local_weight_youtube; ?>" />
                                </TD>
                              </TR>

                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="youtube2" <?php if(in_array('youtube2', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>YouTube (comment search)</LABEL>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_youtube2" id="wpcommentpig_weight_youtube2" value="<?php echo $local_weight_youtube2; ?>" />
                                </TD>
                              </TR>

                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="twitter" <?php if(in_array('twitter', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>Twitter</LABEL>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_twitter" id="wpcommentpig_weight_twitter" value="<?php echo $local_weight_twitter; ?>" />
                                </TD>
                              </TR>

                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="backtype" <?php if(in_array('backtype', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>Backtype</LABEL>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_backtype" id="wpcommentpig_weight_backtype" value="<?php echo $local_weight_backtype; ?>" />
                                </TD>
                              </TR>

                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="friendfeed" <?php if(in_array('friendfeed', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>FriendFeed</LABEL>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_friendfeed" id="wpcommentpig_weight_friendfeed" value="<?php echo $local_weight_friendfeed; ?>" />
                                </TD>
                              </TR>

                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="yahooanswers" <?php if(in_array('yahooanswers', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>Yahoo Answers</LABEL>
                                  <BR />
                                  <SPAN style="font-size:80%; margin-left:20px;" >
                                    AppID:
                                    <INPUT type="text" id="wpcommentpig_yahoo_app_id" name="wpcommentpig_yahoo_app_id" value="<?php echo $local_yahoo_app_id; ?>" size="16" />
                                    (get one <A href="http://developer.yahoo.com/wsregapp/" target="_blank">here</A>)
                                  </SPAN>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_yahooanswers" id="wpcommentpig_weight_yahooanswers" value="<?php echo $local_weight_yahooanswers; ?>" />
                                </TD>
                              </TR>

                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="wordpress" <?php if(in_array('wordpress', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>WordPress.com</LABEL>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_wordpress" id="wpcommentpig_weight_wordpress" value="<?php echo $local_weight_wordpress; ?>" />
                                </TD>
                              </TR>

                              <TR>
                                <TD>
                                  <INPUT type="checkbox" id="wpcommentpig_source" name="wpcommentpig_source[]" value="localdb" <?php if(in_array('localdb', $local_source_array)) { echo "checked"; } ?> ></INPUT>
                                  <LABEL>Local DB</LABEL>
                                  <BR />
                                  <SPAN style="font-size:80%; margin-left:20px;" >
                                    <INPUT id="wpcommentpig_reuse" name="wpcommentpig_reusecomments" type="checkbox" <?php echo $local_reusecomments_text; ?> value="on" />
                                    <LABEL for="wpcommentpig_reusecomments">
                                      don't re-use local comments
                                    </LABEL>
                                    <BR />
                                    <P style="font-size:80%">
                                    </P>
                                  </SPAN>
                                </TD>
                                <TD style="font-size:80%; text-align:center;">
                                  <INPUT type="text" size="3" name="wpcommentpig_weight_localdb" id="wpcommentpig_weight_localdb" value="<?php echo $local_weight_localdb; ?>" />
                                </TD>
                              </TR>
                            </TABLE>
                            <P style="font-size:80%; margin-top:0px;">
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="30%">
                            Names: <?php commentpig_show_tooltip('names', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT type="checkbox" id="wpcommentpig_username_source" name="wpcommentpig_username_source[]" value="comments" <?php if(in_array('comments', $local_username_source_array)) { echo "checked"; } ?> ></INPUT>
                            <LABEL>Comment Sources</LABEL>
                            <BR />

                            <INPUT type="checkbox" id="wpcommentpig_username_source" name="wpcommentpig_username_source[]" value="random" <?php if(in_array('random', $local_username_source_array)) { echo "checked"; } ?> ></INPUT>
                            <LABEL>BlogPiG Random API</LABEL>
                            <BR />

                            <INPUT type="checkbox" id="wpcommentpig_username_source" name="wpcommentpig_username_source[]" value="localdb" <?php if(in_array('localdb', $local_username_source_array)) { echo "checked"; } ?> ></INPUT>
                            <LABEL>Local DB</LABEL>
                            <BR />
                            <BR />

                          </TD>
                        </TR>
                        <TR valign="top">
                          <TD width="100%" colspan="2" style="text-align:right; ">
                            <!---
                            <INPUT class="button" style="float:right; " type="submit" name="submitSources" value="Update Sources &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitRestrictions" value="Update Restrictions &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitUsernameSources" value="Update Sources &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitBadWords" value="Update Bad Words &raquo;" />
                            --->
                            <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="submitSources" value="Save &raquo;" />
                            <?php
                              if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) {
                                echo $pro_link;
                              }
                            ?>
                          </TD>
                        </TR>

                      </TABLE>
                    </p>


                  </div>
                </div>


                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default;'>
                    <span style="vertical-align: top;">Filters</span><?php commentpig_show_header_link('commentpig-filters', $plugin_dir); ?>
                  </h3>
                  <div class="inside">

                    <p>
                      <TABLE width="100%" style="margin-top:12px;">

                        <TR valign="top">
                          <TD width="30%">
                            Keyword in Comment: <?php commentpig_show_tooltip('keyword in comment', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT id="wpcommentpig_keywordexists" name="wpcommentpig_keywordexists" type="checkbox" <?php echo $local_keywordexists_text; ?> value="on" />
                            <LABEL for="wpcommentpig_keywordexists">
                            </LABEL>
                            <P style="font-size:80%; margin-top:0px;">
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>
                        <TR valign="top">
                          <TD width="30%">
                            Comment Size: <?php commentpig_show_tooltip('comment size', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            between
                            <INPUT id="wpcommentpig_commentsizemin" name="wpcommentpig_commentsizemin" type="text" size="4" value="<?php echo $local_commentsizemin; ?>" />
                            and
                            <INPUT id="wpcommentpig_commentsizemax" name="wpcommentpig_commentsizemax" type="text" size="4" value="<?php echo $local_commentsizemax; ?>" />
                            words;
                            <BR/>
                            long comments should be:
                            <INPUT id="wpcommentpig_longcomments" name="wpcommentpig_longcomments" type="radio" value="skip" <?php echo ('skip' == $local_longcomments ? 'checked' : ''); ?> />
                            <LABEL for="wpcommentpig_longcomments">
                              skipped
                            </LABEL>
                            <INPUT id="wpcommentpig_longcomments" name="wpcommentpig_longcomments" type="radio" value="trim" <?php echo ('trim' == $local_longcomments ? 'checked' : ''); ?> />
                            <LABEL for="wpcommentpig_longcomments">
                              trimmed
                            </LABEL>

                            <P style="font-size:80%; margin-top:0px;">
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>
                        <TR valign="top">
                          <TD width="30%">
                            Word Filter: <?php commentpig_show_tooltip('word filter', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT type="radio" id="wpcommentpig_badwords" name="wpcommentpig_badwords" value="on" <?php if($local_badwords == 'on') { echo "checked"; } ?> ></INPUT>
                            <LABEL>on</LABEL>
                            <INPUT type="radio" id="wpcommentpig_badwords" name="wpcommentpig_badwords" value="off" <?php if($local_badwords == 'off') { echo "checked"; } ?> ></INPUT>
                            <LABEL>off</LABEL>
                            <BR /><BR />
                            <TEXTAREA id="wpcommentpig_badwords_list" name="wpcommentpig_badwords_list" rows="10" cols="30"><?php echo $local_badwords_list; ?></TEXTAREA>

                            <P style="font-size:80%; margin-top:0px;">
                            </P>
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="30%">
                            Account Filter: <?php commentpig_show_tooltip('account filter', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT type="radio" id="wpcommentpig_badaccounts" name="wpcommentpig_badaccounts" value="on" <?php if($local_badaccounts == 'on') { echo "checked"; } ?> ></INPUT>
                            <LABEL>on</LABEL>
                            <INPUT type="radio" id="wpcommentpig_badaccounts" name="wpcommentpig_badaccounts" value="off" <?php if($local_badaccounts == 'off') { echo "checked"; } ?> ></INPUT>
                            <LABEL>off</LABEL>
                            <BR /><BR />
                            <TEXTAREA id="wpcommentpig_badaccounts_list" name="wpcommentpig_badaccounts_list" rows="10" cols="30"><?php echo $local_badaccounts_list; ?></TEXTAREA>

                            <P style="font-size:80%; margin-top:0px;">
                            </P>
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="30%">
                            Strip Links: <?php commentpig_show_tooltip('strip links', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT id="wpcommentpig_striplinks" name="wpcommentpig_striplinks" type="checkbox" <?php echo $local_striplinks_text; ?> value="on" />
                            <LABEL for="wpcommentpig_striplinks">
                            </LABEL>
                            <P style="font-size:80%; margin-top:0px;">
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="100%" colspan="2" style="text-align:right; ">
                            <!---
                            <INPUT class="button" style="float:right; " type="submit" name="submitSources" value="Update Sources &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitRestrictions" value="Update Restrictions &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitUsernameSources" value="Update Sources &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitBadWords" value="Update Bad Words &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitSources" value="Update &raquo;" />
                            --->
                            <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="submitFilters" value="Save &raquo;" />
                            <?php
                              if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) {
                                echo $pro_link;
                              }
                            ?>
                          </TD>
                        </TR>

                      </TABLE>
                    </p>


                  </div>
                </div>


                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default;'>
                    <span style="vertical-align: top;">Local DB</span><?php commentpig_show_header_link('commentpig-local-db', $plugin_dir); ?>
                  </h3>
                  <div class="inside">

                    <p>
                      <TABLE width="100%" style="margin-top:12px;">
                        <TR valign="top">
                          <TD width="30%">
                            Upload Comments: <?php commentpig_show_tooltip('upload comments', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                              <INPUT type="file" id="wpcommentpig_comments_upload" name="wpcommentpig_comments_upload" size="24" value="" />
                              <BR />
                              <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="submitComments" value="Append &raquo;" />
                              <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="clearComments" value="Clear DB &raquo;" />
                              <?php
                                if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) {
                                  echo $pro_link;
                                }
                              ?>
                              <!---
                              <INPUT type="submit" name="resetUsedComments" value="Reset Used &raquo;" />
                              --->
                            <P style="font-size:80%" style="margin-top:0px;">
                              Total: <STRONG><?php echo $comments_count; ?></STRONG> <A href="<?php echo $view_all_comments_url; ?>">view</A>
                              ::
                              Used: <STRONG><?php echo $comments_used; ?></STRONG> <A href="<?php echo $config_url . "&resetUsedComments=true"; ?>">reset</A>
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="30%">
                            Upload Names: <?php commentpig_show_tooltip('upload names', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            <INPUT type="file" id="wpcommentpig_users_upload" name="wpcommentpig_users_upload" size="24" value="" />
                            <BR />
                            <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="submitUsers" value="Append &raquo;" />
                            <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="clearUsers" value="Clear DB &raquo;" />
                            <?php
                              if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) {
                                echo $pro_link;
                              }
                            ?>
                            <!---
                            <INPUT type="submit" name="resetUsedUsers" value="Reset Used &raquo;" />
                            --->
                            <P style="font-size:80%">
                              Total: <STRONG><?php echo $users_count; ?></STRONG> <A href="<?php echo $view_all_users_url; ?>">view</A>
                              ::
                              Used: <STRONG><?php echo $users_used; ?></STRONG> <A href="<?php echo $config_url . "&resetUsedUsers=true"; ?>">reset</A>
                            </P>
                          </TD>
                        </TR>

                      </TABLE>
                    </p>

                  </div>
                </div>

                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default;'>
                    <span style="vertical-align: top;">Links</span><?php commentpig_show_header_link('commentpig-links', $plugin_dir); ?>
                  </h3>
                  <div class="inside">

                    <p>
                      <TABLE width="100%" style="margin-top:12px;">
                        <TR valign="top">
                          <TD width="30%">
                            Global: <?php commentpig_show_tooltip('global', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            link
                            <INPUT id="wpcommentpig_userlinkrate" name="wpcommentpig_userlinkrate" type="text" size="3" value="<?php echo $local_userlinkrate; ?>" />
                            % of all comment names
                            <P style="font-size:80%">
                            </P>

                            <P style="font-size:100%; margin-left:24px !important /*Firefox*/; margin-left:28px /*IE6*/; ">
                              <SELECT id="wpcommentpig_userlinkrelnofollow" name="wpcommentpig_userlinkrelnofollow" style="margin-top: -2px;">
                                <OPTION value="do" <?php if('do' == $local_userlinkrelnofollow) { echo "selected"; } ?>>DO</OPTION>
                                <OPTION value="no" <?php if('no' == $local_userlinkrelnofollow) { echo "selected"; } ?>>NO</OPTION>
                              </SELECT>
                              Follow global links
                              <P style="font-size:80%">
                              </P>
                            </P>

                            use
                            <INPUT type="checkbox" id="wpcommentpig_userlinktype" name="wpcommentpig_userlinktype[]" value="random" <?php if(in_array('random', $local_userlinktype_array)) { echo "checked"; } ?> ></INPUT>
                            <LABEL>random sites</LABEL>
                            <INPUT type="checkbox" id="wpcommentpig_userlinktype" name="wpcommentpig_userlinktype[]" value="authority" <?php if(in_array('authority', $local_userlinktype_array)) { echo "checked"; } ?> ></INPUT>
                            <LABEL>authority sites</LABEL>
                            <P>
                            </P>
                            <BR />
                            <BR />
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="30%">
                            My Sites: <?php commentpig_show_tooltip('my sites', $plugin_dir); ?> <BR />
                          </TD>
                          <TD width="70%">
                            link
                            <INPUT id="wpcommentpig_ownlinkrate" name="wpcommentpig_ownlinkrate" type="text" size="3" value="<?php echo $local_ownlinkrate; ?>" />
                            % of linked comment names to my sites
                            <P style="font-size:80%">
                            </P>

                            <P style="font-size:100%; margin-left:24px !important /*Firefox*/; margin-left:28px /*IE6*/; ">
                              <SELECT id="wpcommentpig_ownlinkrelnofollow" name="wpcommentpig_ownlinkrelnofollow" style="margin-top: -2px;">
                                <OPTION value="do" <?php if('do' == $local_ownlinkrelnofollow) { echo "selected"; } ?>>DO</OPTION>
                                <OPTION value="no" <?php if('no' == $local_ownlinkrelnofollow) { echo "selected"; } ?>>NO</OPTION>
                              </SELECT>
                              Follow my site links
                              <P style="font-size:80%">
                              </P>
                            </P>

                            use these sites: <BR />
                            <TEXTAREA id="wpcommentpig_ownlinks" name="wpcommentpig_ownlinks" rows="10" cols="30"><?php echo $local_ownlinks; ?></TEXTAREA>
                            <P style="font-size:80%">
                            </P>
                          </TD>
                        </TR>

                        <TR valign="top">
                          <TD width="100%" colspan="2" style='text-align:right; '>
                            <!---
                            <INPUT class="button" style="float:right; " type="submit" name="submitLinkingGlobal" value="Update Global Options   &raquo;" />
                            <INPUT class="button" style="float:right; " type="submit" name="submitLinkingOwn" value="Update Own Links Options   &raquo;" />
                            --->
                            <INPUT class="button" <?php if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) { echo " disabled "; } ?> type="submit" name="submitLinks" value="Save &raquo;" />
                            <?php
                              if(!function_exists('commentpig_pro_api_check') || !@commentpig_pro_api_check()) {
                                echo $pro_link;
                              }
                            ?>

                            <BR />
                          </TD>
                        </TR>

                      </TABLE>
                    </p>


                  </div>
                </div>

                <?php
                  # Clone Settings...
                  if(function_exists('commentpig_pro_show_clone') && @commentpig_pro_api_check()) {
                    commentpig_pro_show_clone($plugin_dir);
                  }
                  else {
                ?>
                <div class='postbox '>
                  <h3 class='hndle' style='cursor:default;'>
                    <span style="vertical-align: top;">Clone</span><?php commentpig_show_header_link('blogpig-clone-settings', $plugin_dir); //, '', '#AAAAAA'); ?>
                  </h3>
                  <div class='inside'>

                    <p>
                      <TABLE width='100%' style='margin-top:12px;'>
                        <TR>
                          <TD width='40%' valign='top'>
                            Initial Settings: <?php commentpig_show_tooltip('initial settings', $plugin_dir); ?>
                          </TD>
                          <TD width='60%'>
                            <INPUT type="button" disabled class="button" name="wpcommentpig_pro_clone_setings" value="Export Settings &raquo;" />
                              <?php echo $pro_link; ?>
                            <P style='font-size:80%; margin-top:8px;'>
                            </P>
                          </TD>
                        </TR>
                      </TABLE>
                    </p>

                  </div> <!--- class='inside' --->
                </div> <!--- class='postbox ' --->
                <?php
                  }
                ?>

                <!--- Content... --->
                <div id="pagecommentstatusdiv" class="postbox " >
                  <h3 class='hndle' style='cursor:default;'>
                    <span style="vertical-align: top;">Log</span><?php #commentpig_show_header_link('blogpig-log', $plugin_dir); ?>
                  </h3>
                  <div class="inside">

                    <p>
                      <!--- Displaying the log file --->
                      <?php if(function_exists('commentpig_log_show')) { commentpig_log_show(); } ?>
                    </p>

                  </div>
                </div>


                <input type="hidden" name="wpblogpig_active" value="wpcommentpig" />
                <input type="submit" class="button-primary" name="wpcommentpig_submit" value="Save All &raquo;" />
                <BR /><BR />

              </div> <!--- class='meta-box-sortables' --->

            </div> <!--- class="has-sidebar-content" --->

          </div> <!--- class="has-sidebar" --->

        </div> <!--- class="metabox-holder" --->

      </form>

    <?php

    unset($local_source_array);
    unset($local_username_source_array);
    unset($local_userlinktype_array);

  }

?>
