/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileSystemView;

public class MyListCellRenderer
implements ListCellRenderer {
    private JLabel label = new JLabel();
    private FileSystemView fsv;
    private DirectoryModel dirModel;

    MyListCellRenderer(DirectoryModel dirModel) {
        this.label.setOpaque(true);
        this.fsv = FileSystemView.getFileSystemView();
        this.dirModel = dirModel;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof File) {
            File file = (File)value;
            try {
                this.label.setText(this.fsv.getSystemDisplayName(file));
                this.label.setToolTipText(this.fsv.getSystemTypeDescription(file));
                IndentIcon indentIcon = new IndentIcon(this.fsv.getSystemIcon(file), this.dirModel.getDepth(file));
                this.label.setIcon(indentIcon);
            }
            catch (NoSuchMethodError error) {
                this.label.setText(file.getName());
                this.label.setToolTipText(file.getAbsolutePath());
            }
        }
        if (isSelected) {
            this.label.setBackground(list.getSelectionBackground());
            this.label.setForeground(list.getSelectionForeground());
        } else {
            this.label.setBackground(list.getBackground());
            this.label.setForeground(list.getForeground());
        }
        return this.label;
    }
}

