/*
 * Decompiled with CFR 0.152.
 */
package JUpload.http;

import JUpload.Messages;
import JUpload.gui.UploadStatus;
import JUpload.http.AbstractHTTPRequest;
import JUpload.http.HttpResponse;
import JUpload.http.MimeHeader;
import JUpload.network.MySSLSocketFactory;
import JUpload.network.MyTCPSocketFactory;
import JUpload.network.Protocol;
import JUpload.swingVersion.JUpload;
import JUpload.swingVersion.UploadJob;
import JUpload.utilities.Configurator;
import JUpload.utilities.MyFile;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import netscape.javascript.JSObject;

public class HTTPPutRequest
extends AbstractHTTPRequest {
    private static final Logger LOG = Logger.getLogger((class$JUpload$http$HTTPPutRequest == null ? (class$JUpload$http$HTTPPutRequest = HTTPPutRequest.class$("JUpload.http.HTTPPutRequest")) : class$JUpload$http$HTTPPutRequest).getName());
    protected static int threadCounter = 0;
    String strHostname;
    String tagName = Configurator.getHTTPTagName();
    Vector arrFilenames = new Vector();
    int counter = 0;
    int iPort;
    private JUpload applet;
    private UploadStatus myStatus;
    private Vector arrMimeHeaders = new Vector();
    private Vector uploadJobs;
    private boolean finished;
    private boolean running;
    static /* synthetic */ Class class$JUpload$http$HTTPPutRequest;

    public HTTPPutRequest(JUpload parent, Vector t_uploadJobs) {
        this.applet = parent;
        this.uploadJobs = t_uploadJobs;
    }

    public void setActionURL(URL url) {
        LOG.info("Setting actionURL to " + url);
        this.actionURL = url;
        this.iPort = url.getPort() != -1 ? url.getPort() : 80;
        this.strHostname = url.getHost();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setLastRequest(boolean b) {
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean performRequest() throws IOException {
        String msg;
        LOG.info("Performing HTTP PUT request");
        if (this.uploadJobs.size() > 1) {
            this.myStatus.setJobProgressbarVisible(true);
        } else {
            this.myStatus.setJobProgressbarVisible(false);
        }
        if (this.arrFilenames.size() == 1) {
            this.myStatus.setTotalProgressbarVisible(false);
        } else {
            this.myStatus.setTotalProgressbarVisible(true);
        }
        if (this.actionURL.getProtocol().equalsIgnoreCase("https")) {
            LOG.info("Registering Secure HTTP protocol");
            try {
                Protocol.registerProtocol("https", new Protocol("https", new MySSLSocketFactory(), 443));
            }
            catch (Exception e) {
                msg = "Error registering protocol";
                LOG.log(Level.SEVERE, msg, e);
            }
        } else if (this.actionURL.getProtocol().equalsIgnoreCase("http")) {
            LOG.info("Registering HTTP protocol");
            try {
                Protocol.registerProtocol("http", new Protocol("http", new MyTCPSocketFactory(), 80));
            }
            catch (Exception e) {
                msg = "Error registering protocol";
                LOG.log(Level.SEVERE, msg, e);
            }
        } else {
            LOG.warning("Unknown protocol: " + this.actionURL.getProtocol());
        }
        if (!this.createHttpConnection()) {
            String errmsg = "HTTPPutRequest() could not create connection to webserver: " + this.actionURL.getHost();
            LOG.warning(errmsg);
            this.applet.statuspanel.remove(this.myStatus);
            this.applet.controlPanel.repaint();
            this.running = false;
            this.finished = true;
            return false;
        }
        this.createHeaders();
        this.createStreams();
        if (null == this.getOutputStream()) {
            this.applet.statuspanel.remove(this.myStatus);
            this.applet.controlPanel.repaint();
            this.running = false;
            this.finished = true;
            return false;
        }
        String errorMessage = this.iterateFiles();
        if (errorMessage != null) {
            this.showErrorMessage(errorMessage);
        }
        this.getOutputStream().flush();
        this.getOutputStream().close();
        LOG.info("Upload finished, reenabling buttons");
        this.parent.add.setEnabled(true);
        this.parent.stopButton.setEnabled(false);
        URL urlCompleteURL = Configurator.getCompleteURL();
        if (null != urlCompleteURL) {
            LOG.finer("Trying to redirect browser to " + urlCompleteURL);
            this.applet.applet.m_Context.showDocument(urlCompleteURL);
        }
        LOG.finer("Request finished, now notifying javascript UploadedListener");
        if (this.applet.applet.javascriptUploadedRegistered) {
            JSObject win = this.applet.applet.jsBrowserWindow;
            win.call(this.applet.applet.javascriptUploadedName, null);
        }
        return true;
    }

    public void run() {
        if (!this.finished) {
            this.running = true;
        }
        this.myStatus = UploadStatus.getInstance();
        this.myStatus.setPreferredSize(new Dimension(this.applet.statuspanel.getWidth(), this.applet.statuspanel.getHeight()));
        this.myStatus.doResize();
        this.applet.statuspanel.add(this.myStatus);
        this.myStatus.start();
        try {
            for (int i = 0; i < this.uploadJobs.size(); ++i) {
                this.myStatus.setJobsValue(i, this.uploadJobs.size());
                UploadJob job = (UploadJob)this.uploadJobs.get(i);
                this.arrFilenames = job.getFiles();
                this.performRequest();
                job.getFiles().clear();
                this.uploadJobs.remove(job);
                if (!this.running) break;
            }
            this.myStatus.setMessage(Messages.getString("HTTPPutRequest.0"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.myStatus.stop();
        this.applet.statuspanel.remove(this.myStatus);
        if (null != this.applet && null != this.applet.controlPanel) {
            this.applet.controlPanel.repaint();
        }
        this.applet.doLayout();
        this.applet.validate();
        this.running = false;
        this.finished = true;
        this.applet.getQueueSelectedFiles().removeUploadedFiles();
    }

    private long getRemoteFilesize(MimeHeader mimeheader) throws IOException, SocketException {
        String strHeadHeader = mimeheader.getHeadHeader(this.actionURL.getHost());
        LOG.finer("Sending HEAD Header: [" + strHeadHeader + "]");
        this.getOutputStream().write(strHeadHeader.getBytes());
        this.getOutputStream().flush();
        HttpResponse resp = this.getResponse();
        long remoteSize = resp.getContentLength();
        int status = resp.getStatusCode();
        String strReasonPhrase = resp.getStatusMessage();
        if (resp.isConnectionClosed()) {
            LOG.info("Server closes connection, will try to reopen now.");
            this.getInputStream().close();
            this.getOutputStream().close();
            this.createHttpConnection();
            this.createStreams();
        }
        if (status >= 500) {
            this.showErrorMessage(status + Messages.getString("HTTPPutRequest.42") + Messages.getString("HTTPPutRequest.43") + strReasonPhrase);
            return 0L;
        }
        if (status >= 400 && status != 404) {
            this.showErrorMessage(status + Messages.getString("HTTPPutRequest.44") + Messages.getString("HTTPPutRequest.45") + strReasonPhrase);
            return 0L;
        }
        if (status == 200) {
            return remoteSize;
        }
        return 0L;
    }

    private void createHeaders() {
        LOG.log(Level.FINER, "Creating MIME headers");
        for (int i = 0; i < this.arrFilenames.size(); ++i) {
            MyFile f = (MyFile)this.arrFilenames.elementAt(i);
            this.arrMimeHeaders.addElement(new MimeHeader(f));
        }
    }

    private String iterateFiles() throws IOException, SocketException {
        LOG.info("Iterating queued files");
        int fileCounter = 0;
        Iterator iter = this.arrMimeHeaders.iterator();
        while (iter.hasNext() && this.running) {
            this.myStatus.setTotalValue(++fileCounter, this.arrMimeHeaders.size());
            MimeHeader mimeheader = (MimeHeader)iter.next();
            long remoteSize = 0L;
            boolean stop = false;
            int retryCounter = 0;
            long lastOffset = 0L;
            do {
                LOG.finest("retryCounter " + retryCounter + " > maxRetries " + this.getMaxRetries());
                if (retryCounter > this.getMaxRetries()) {
                    String errorMessage = Messages.getString("HTTPPutRequest.errormessage.putnotsupported");
                    LOG.warning(errorMessage);
                    stop = true;
                    this.showErrorMessage(errorMessage);
                    mimeheader.getFile().setFailure(true);
                }
                if ((remoteSize = this.getRemoteFilesize(mimeheader)) == -1L) {
                    remoteSize = 0L;
                }
                this.getOutputStream().flush();
                LOG.finest("  getRemoteFilesize() said " + remoteSize);
                if (remoteSize == mimeheader.getFile().length()) {
                    LOG.finest("File already on server with correct file size. Skipping");
                    mimeheader.getFile().setUploaded(true);
                    this.parent.getQueueSelectedFiles().notifyListenersChanged();
                    this.myStatus.setMessage(mimeheader.getFile() + Messages.getString("HTTPPutRequest.1"));
                    break;
                }
                long offset = remoteSize;
                if (offset == lastOffset) {
                    LOG.finest("Increasing retry counter, as the offset stayed the same:" + offset);
                    ++retryCounter;
                }
                LOG.finest("Skipping to offset:" + offset);
                long maxlength = Configurator.getPUTFragmentSize();
                LOG.finest("Maximum size to send with one fragment:" + maxlength);
                String putHeader = mimeheader.getPutHeader(this.actionURL.getHost(), maxlength, offset);
                if (offset > 0L) {
                    this.myStatus.setMessage(Messages.getString("HTTPPutRequest.2") + offset);
                } else {
                    this.myStatus.setMessage(Messages.getString("HTTPPutRequest.3"));
                }
                LOG.finest("Sending PUT Header: [" + putHeader + "]");
                this.getOutputStream().write(putHeader.getBytes());
                long bytesSent = this.sendFileData(mimeheader, offset, maxlength);
                LOG.finer("Sent bytes: " + bytesSent);
                LOG.finest("Flusing output stream");
                this.getOutputStream().flush();
                HttpResponse resp = this.getResponse();
                if (resp.isSuccessful()) {
                    this.applet.serverResponse.addResponse(resp.getBody());
                } else {
                    LOG.warning("HTTP Response says Request was unsuccessful");
                }
                this.myStatus.setMessage(Messages.getString("HTTPPutRequest.4"));
                if (!this.getResponse().isConnectionClosed()) continue;
                LOG.finer("Reopening streams");
                this.getInputStream().close();
                this.getOutputStream().close();
                this.createHttpConnection();
                this.createStreams();
            } while (remoteSize != mimeheader.getFile().length() && !stop);
            LOG.finer("File done, sending next file");
            this.myStatus.setMessage(Messages.getString("HTTPPutRequest.5"));
        }
        this.myStatus.setMessage(Messages.getString("HTTPPutRequest.6"));
        return null;
    }

    private long sendFileData(MimeHeader mimeheader, long offset, long maxlength) throws IOException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("offset:" + offset);
            LOG.finest("maxlength:" + maxlength);
        }
        this.myStatus.setFilename(mimeheader.getFile().getName());
        this.myStatus.setProgressbarVisible(true);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(mimeheader.getFile());
            ((InputStream)fin).skip(offset);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return 0L;
        }
        long bytesSent = 0L;
        byte[] buffer = new byte[16384];
        try {
            int c;
            while (this.running && !this.isFinished() && (c = ((InputStream)fin).read(buffer)) != -1) {
                if (bytesSent < maxlength) {
                    try {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Number of bytes in buffer:" + c);
                        }
                        this.getOutputStream().write(buffer, 0, c);
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Flushing");
                        }
                        this.getOutputStream().flush();
                    }
                    catch (SocketException se) {
                        se.printStackTrace();
                        JOptionPane.showMessageDialog(this.applet.applet, Messages.getString("HTTPPutRequest.84"));
                        return bytesSent;
                    }
                    this.counter += c;
                    this.myStatus.setValue(offset + (bytesSent += (long)c), mimeheader.getFile().length());
                    continue;
                }
                int rest = (int)(maxlength - bytesSent);
                if (rest <= 0) break;
                this.getOutputStream().write(buffer, 0, rest);
                this.counter += rest;
                bytesSent += (long)rest;
                break;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Flusing output stream and closing file input stream");
            }
            this.getOutputStream().flush();
            ((InputStream)fin).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.myStatus.setProgressbarVisible(false);
        return bytesSent;
    }

    public void stopUpload() {
        this.running = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

