/*
 * Decompiled with CFR 0.152.
 */
package JUpload.http;

import JUpload.Messages;
import JUpload.gui.LoginFrame;
import JUpload.gui.UploadStatus;
import JUpload.http.AbstractHTTPRequest;
import JUpload.http.FormElement;
import JUpload.http.FormFieldMimeHeader;
import JUpload.http.HttpResponse;
import JUpload.http.JSFormParser;
import JUpload.http.MimeHeader;
import JUpload.network.MySSLSocketFactory;
import JUpload.network.MyTCPSocketFactory;
import JUpload.network.Protocol;
import JUpload.swingVersion.JUpload;
import JUpload.swingVersion.UploadJob;
import JUpload.utilities.Base64;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import JUpload.utilities.ProxyConfig;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import netscape.javascript.JSObject;

public class HTTPPostRequest
extends AbstractHTTPRequest {
    protected static int threadCounter = 0;
    String boundary;
    String strHostname;
    String tagName = Configurator.getHTTPTagName();
    Vector arrFilenames = new Vector();
    long counter = 0L;
    int iPort;
    private StringBuffer m_sbHeader = new StringBuffer();
    private UploadStatus myStatus;
    private Vector arrFormFields = new Vector();
    private Vector arrMimeHeaders = new Vector();
    private boolean LastRequest = false;
    private boolean finished = false;
    private boolean running = false;
    private long contentLength;
    private long totalBytesSent = 0L;
    private Vector uploadJobs;
    private boolean stopped = true;

    public HTTPPostRequest(JUpload t_parent, Vector t_uploadJobs) {
        this.parent = t_parent;
        this.uploadJobs = t_uploadJobs;
        if (null == t_parent) {
            this.standalone = true;
        }
    }

    public void setActionURL(URL url) {
        Debug.println(this, "HTTPPostRequest() setting action URL");
        this.actionURL = url;
        this.iPort = url.getPort() != -1 ? url.getPort() : 80;
        this.strHostname = url.getHost();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setLastRequest(boolean flag) {
        this.LastRequest = flag;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean performRequest() throws IOException {
        HttpResponse resp;
        boolean connOk;
        this.boundary = this.generateBoundary();
        Debug.println(this, "HTTPPostRequest() starting REQUEST");
        Debug.println(this, "HTTPPostRequest() performRequest() we have " + this.arrFilenames.size() + "files:");
        for (int x = 0; x < this.arrFilenames.size(); ++x) {
            Debug.println(this, this.arrFilenames.get(x).toString());
        }
        this.myStatus.setProgressbarVisible(true);
        if (this.arrFilenames.size() == 1) {
            if (!this.standalone) {
                this.myStatus.setTotalProgressbarVisible(false);
            }
        } else if (!this.standalone) {
            this.myStatus.setTotalProgressbarVisible(true);
        }
        if (this.actionURL.getProtocol().equalsIgnoreCase("https")) {
            if (!this.standalone) {
                this.myStatus.setMessage(Messages.getString("HTTPPostRequest.8"));
            }
            Protocol.registerProtocol("https", new Protocol("https", new MySSLSocketFactory(), 443));
        } else if (this.actionURL.getProtocol().startsWith("http")) {
            if (!this.standalone) {
                this.myStatus.setMessage(Messages.getString("HTTPPostRequest.0"));
            }
            Protocol.registerProtocol("http", new Protocol("http", new MyTCPSocketFactory(), 80));
        } else {
            Debug.println(this, "Unknown protocol:" + this.actionURL.getProtocol());
        }
        if (!this.standalone) {
            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.13"));
        }
        if (!this.createHttpConnection()) {
            Debug.println(this, "HTTPPostRequest() could not create connection to webserver.");
            return false;
        }
        Debug.println(this, "HTTPPostRequest() performRequest() creating files headers");
        if (!this.standalone) {
            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.16"));
        }
        this.arrMimeHeaders.clear();
        this.arrFormFields.clear();
        if (Configurator.getUseAbsolutePaths()) {
            this.createAdditionalPostVariables();
        }
        this.createAdditionalUserPostVariables();
        this.createHeaders();
        this.calculateSizes();
        this.createHTTPHeader();
        this.createHttpConnection();
        this.createStreams();
        if (!this.standalone) {
            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.21"));
        }
        try {
            this.sendHeader();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Debug.println(this, "HTTPPostRequest() performRequest() checking for writer=" + this.getOutputStream());
        if (null == this.getOutputStream()) {
            if (!this.standalone) {
                this.parent.statuspanel.remove(this.myStatus);
                this.parent.controlPanel.repaint();
                this.myStatus.stop();
            }
            if (!this.standalone) {
                this.parent.add.setEnabled(true);
            }
            return false;
        }
        try {
            this.getOutputStream().write("--".getBytes());
            this.getOutputStream().write(this.boundary.getBytes());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (this.arrFormFields.size() > 0) {
            Iterator iter = this.arrFormFields.iterator();
            while (iter.hasNext()) {
                FormFieldMimeHeader ffmh = (FormFieldMimeHeader)iter.next();
                String data = ffmh.getHeader() + ffmh.getContent() + ffmh.getFooter();
                Debug.println(this, "sending form field [" + data + "]");
                try {
                    this.getOutputStream().write(data.getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Debug.println(this, "HTTPPostRequest() performRequest() iterating files");
        if (!this.standalone) {
            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.27"));
        }
        if (!(connOk = this.iterateFiles())) {
            return false;
        }
        do {
            if (!(resp = this.getResponse()).isSuccessful()) continue;
            this.parent.serverResponse.addResponse(resp.getBody());
        } while (resp.getStatusCode() == 100);
        try {
            if (connOk) {
                this.getOutputStream().flush();
            }
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        if (!this.standalone) {
            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.29"));
        }
        if (!this.standalone) {
            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.31"));
        }
        if (this.getResponse().isConnectionClosed()) {
            this.getInputStream().close();
        }
        Debug.println(this, "HTTPPostRequest() REQUEST ends");
        Debug.println(this, "Upload finished. lastRequest=" + this.LastRequest);
        if (this.LastRequest) {
            if (!this.standalone) {
                Debug.println(this, "HTTPPostRequest() performRequest() uploadapplet is " + this.parent.applet);
            }
            if (this.getResponse().isSuccessful()) {
                URL urlCompleteURL = Configurator.getCompleteURL();
                if (null != urlCompleteURL) {
                    Debug.println(this, "HTTPPostRequest() performRequest() completeURL is not empty. Redirecting user...to=" + urlCompleteURL);
                    try {
                        if (Configurator.getTargetFrame().equalsIgnoreCase("")) {
                            if (!this.standalone) {
                                this.parent.applet.m_Context.showDocument(urlCompleteURL);
                            }
                        } else if (!this.standalone) {
                            this.parent.applet.m_Context.showDocument(urlCompleteURL, Configurator.getTargetFrame());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                URL urlErrorURL = Configurator.getErrorURL();
                if (null != urlErrorURL) {
                    Debug.println(this, "HTTPPostRequest() performRequest() errorURL is not empty. Redirecting user...to=" + urlErrorURL);
                    try {
                        if (!this.standalone) {
                            this.parent.applet.m_Context.showDocument(urlErrorURL);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Debug.println(this, "HTTPPostRequest() performRequest() finished.");
        try {
            if (!this.standalone && this.parent.applet.javascriptUploadedRegistered) {
                JSObject win = this.parent.applet.jsBrowserWindow;
                win.call(this.parent.applet.javascriptUploadedName, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Configurator.getReplaceDocument()) {
            Debug.println(this, "Replacing html document with server response: " + this.getResponse().getBody().length() + " bytes");
            this.parent.applet.jsBrowserWindow.call("replaceDocument", this.getResponse().getBody());
        }
        return true;
    }

    private void createAdditionalUserPostVariables() {
        Map additionalFields = Configurator.getAdditionalPOSTFields();
        Iterator keyIter = additionalFields.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String value = (String)additionalFields.get(key);
            this.arrFormFields.addElement(new FormFieldMimeHeader(key, value, this.boundary));
        }
    }

    private void createAdditionalPostVariables() {
        Debug.println(this, "createAbsolutePathnameObjects()");
        for (int i = 0; i < this.arrFilenames.size(); ++i) {
            MyFile myElement = (MyFile)this.arrFilenames.elementAt(i);
            this.arrFormFields.addElement(new FormFieldMimeHeader(this.tagName + String.valueOf(i) + "_absolutePath", myElement.getAbsolutePath(), this.boundary));
            if (myElement.isVirtual()) {
                this.arrFormFields.addElement(new FormFieldMimeHeader(this.tagName + String.valueOf(i) + "_relativePath", myElement.getVirtualRelativePathname(), this.boundary));
            } else {
                this.arrFormFields.addElement(new FormFieldMimeHeader(this.tagName + String.valueOf(i) + "_relativePath", myElement.getRelativeFilename(), this.boundary));
            }
            this.arrFormFields.addElement(new FormFieldMimeHeader(this.tagName + String.valueOf(i) + "_lastModified", String.valueOf(myElement.lastModified()), this.boundary));
            if (myElement.getMD5Hash() == null) continue;
            this.arrFormFields.addElement(new FormFieldMimeHeader(this.tagName + String.valueOf(i) + "_md5hash", String.valueOf(myElement.getMD5Hash()), this.boundary));
        }
    }

    public void run() {
        this.running = true;
        Debug.println(this, "Upload thread started and running...");
        if (!this.standalone) {
            this.myStatus = UploadStatus.getInstance();
            this.myStatus.start();
            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.6"));
        }
        if (this.uploadJobs.size() > 1) {
            this.myStatus.setJobProgressbarVisible(true);
        } else {
            this.myStatus.setJobProgressbarVisible(false);
        }
        Debug.println(this, "HTTPPostRequest() Iterating jobs");
        for (int i = 0; i < this.uploadJobs.size(); ++i) {
            this.myStatus.setJobsValue(i, this.uploadJobs.size());
            UploadJob job = (UploadJob)this.uploadJobs.get(i);
            this.arrFilenames = job.getFiles();
            if (i == this.uploadJobs.size() - 1) {
                this.setLastRequest(true);
            }
            boolean ok = false;
            try {
                ok = this.performRequest();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!ok) {
                this.arrFilenames.clear();
                this.arrMimeHeaders.clear();
                this.arrFormFields.clear();
                this.contentLength = 0L;
                this.totalBytesSent = 0L;
                this.myStatus.stop();
                this.parent.statuspanel.remove(this.myStatus);
                this.parent.controlPanel.repaint();
                this.parent.validate();
                this.running = false;
                this.parent.add.setEnabled(true);
                this.finished = true;
                return;
            }
            this.arrFilenames.clear();
            this.arrMimeHeaders.clear();
            this.arrFormFields.clear();
            this.contentLength = 0L;
            this.totalBytesSent = 0L;
        }
        if (!this.standalone) {
            this.parent.statuspanel.remove(this.myStatus);
            if (null != this.parent && null != this.parent.controlPanel) {
                this.parent.controlPanel.repaint();
            }
            this.myStatus.stop();
            this.parent.add.setEnabled(true);
        }
        Debug.println(this, "Upload thread ended...");
        if (!this.standalone) {
            this.parent.validate();
        }
        this.running = false;
        this.finished = true;
        if (!this.standalone) {
            this.parent.add.setEnabled(true);
        }
        this.parent.stopButton.setEnabled(false);
        this.parent.getQueueSelectedFiles().removeUploadedFiles();
    }

    private String WWWAuthentificationHeader() {
        String strCheck = Configurator.getStrWWWAuthentificationString();
        if (strCheck != null && !strCheck.equalsIgnoreCase("")) {
            return strCheck;
        }
        LoginFrame loginframe = new LoginFrame();
        StringBuffer theUID = new StringBuffer().append(loginframe.getUsername());
        if (loginframe.getPassword() != null) {
            theUID.append(":").append(loginframe.getPassword());
        }
        String encoding = new String(Base64.encode(theUID.toString().getBytes()));
        String strAuthHeader = "Authorization: Basic " + encoding + "\r\n";
        Debug.println(this, "HTTPPostRequest() WWWAuthentificationHeader() is [" + strAuthHeader + "]");
        Configurator.setStrWWWAuthentificationString(strAuthHeader);
        return strAuthHeader;
    }

    private void calculateSizes() {
        Iterator iter;
        if (this.arrFormFields.size() > 0) {
            this.contentLength += (long)(2 + this.boundary.length());
            iter = this.arrFormFields.iterator();
            while (iter.hasNext()) {
                FormFieldMimeHeader ffmh = (FormFieldMimeHeader)iter.next();
                this.contentLength += (long)ffmh.getHeader().length();
                this.contentLength += ffmh.getContentLength();
                this.contentLength += (long)ffmh.getFooter().length();
            }
        } else {
            this.contentLength += (long)(2 + this.boundary.length());
        }
        iter = this.arrMimeHeaders.iterator();
        while (iter.hasNext()) {
            MimeHeader element = (MimeHeader)iter.next();
            this.contentLength += (long)element.getHeader().length();
            this.contentLength += element.getContentLength();
            if (iter.hasNext()) {
                this.contentLength += (long)element.getFooter().length();
                continue;
            }
            this.contentLength += (long)element.getLastFooter().length();
        }
    }

    private void createHTTPHeader() {
        String strQueryString = this.actionURL.getQuery();
        if (null == strQueryString) {
            strQueryString = "";
        }
        if (strQueryString.equals("")) {
            Debug.println(this, "HTTPPostRequest() createHTTPHeader() actionURL.getQuery is empty.");
        } else {
            Debug.println(this, "HTTPPostRequest() createHTTPHeader() query string added.");
            strQueryString = "?" + this.actionURL.getQuery();
        }
        this.m_sbHeader.delete(0, this.m_sbHeader.length());
        this.m_sbHeader.append("POST ");
        if (ProxyConfig.useProxy) {
            this.m_sbHeader.append(this.actionURL);
        } else {
            this.m_sbHeader.append(this.actionURL.getPath()).append(strQueryString);
        }
        this.m_sbHeader.append(" HTTP/1.1").append("\r\n");
        this.m_sbHeader.append("Host: ").append(this.actionURL.getHost()).append("\r\n");
        this.m_sbHeader.append("User-Agent: ").append(Configurator.strUserAgent).append("\r\n");
        this.m_sbHeader.append("Referer: ").append(this.parent.applet.getCodeBase().toString()).append("\r\n");
        this.m_sbHeader.append("From: ").append(Configurator.strApplicationEmail).append("\r\n");
        this.m_sbHeader.append("Accept: text/*;q=1.0, */*;q=0.0").append("\r\n");
        this.m_sbHeader.append("Cache-Control: no-cache").append("\r\n").append("Pragma: no-cache").append("\r\n");
        this.m_sbHeader.append("Accept-Charset: ISO-8859-1;q=0.9,*;q=0.1").append("\r\n");
        this.m_sbHeader.append("Connection: close").append("\r\n");
        try {
            JSObject jsWindow = this.parent.applet.jsBrowserWindow;
            String cookieString = jsWindow.eval("document.cookie").toString();
            Debug.println(this, "Got cookie:" + cookieString);
            if (!cookieString.equals("")) {
                this.m_sbHeader.append("Cookie: ").append((Object)cookieString).append("\r\n");
            }
        }
        catch (Exception jse) {
            // empty catch block
        }
        List additionalHeaders = Configurator.getAdditionalHeaders();
        Iterator iter = additionalHeaders.iterator();
        while (iter.hasNext()) {
            this.m_sbHeader.append((String)iter.next());
            this.m_sbHeader.append("\r\n");
        }
        if (!Configurator.getBrowserCookie().equalsIgnoreCase("")) {
            Debug.println(this, "HTTPPostRequest() createHTTPHeader() adding Cookie header from parameter");
            this.m_sbHeader.append("Cookie: ").append(Configurator.getBrowserCookie()).append("\r\n");
        }
        try {
            if (Configurator.getAskAuthentificate()) {
                Debug.println(this, "HTTPPostRequest() createHTTPHeader() WWW-Authentification is configured as 'obligatory'. User must enter username and password.");
                this.m_sbHeader.append(this.WWWAuthentificationHeader());
            } else if (!Configurator.getUsePresetAuthentification().equals("")) {
                this.m_sbHeader.append("Authorization: Basic ").append(Configurator.getUsePresetAuthentification()).append("\r\n");
                Debug.println(this, "HTTPPostRequest() createHTTPHeader() Using preset authentification.");
            } else {
                Debug.println(this, "HTTPPostRequest() createHTTPHeader() No WWW-Authentification is needed.");
            }
        }
        catch (NullPointerException e) {
            Debug.println(this, "HTTPPostRequest() createHTTPHeader() Could not find WWW-Authentification option.");
        }
        if (Configurator.getFixJakartaBug()) {
            this.m_sbHeader.append("Content-Type: multipart/mixed; boundary=").append(this.boundary);
        } else {
            this.m_sbHeader.append("Content-Type: multipart/form-data; boundary=").append(this.boundary);
        }
        this.m_sbHeader.append("\r\n");
        this.m_sbHeader.append("Content-Length: ").append(this.contentLength).append("\r\n");
        this.m_sbHeader.append("\r\n");
        Debug.println(this, "HTTPPostRequest() http header=" + this.m_sbHeader.toString());
    }

    private void createHeaders() {
        Debug.println(this, "createHeaders()");
        JSFormParser jsfp = new JSFormParser(this.parent.applet);
        if (jsfp.hasNext()) {
            while (jsfp.hasNext()) {
                FormElement myElement = (FormElement)jsfp.next();
                boolean add = true;
                if (myElement.type.equalsIgnoreCase("checkbox") && myElement.checked.equalsIgnoreCase("false")) {
                    add = false;
                }
                if (myElement.type.equalsIgnoreCase("radio") && myElement.checked.equalsIgnoreCase("false")) {
                    add = false;
                }
                if (!add) continue;
                this.arrFormFields.addElement(new FormFieldMimeHeader(myElement.name, myElement.value, this.boundary));
            }
        }
        for (int i = 0; i < this.arrFilenames.size(); ++i) {
            MyFile f = (MyFile)this.arrFilenames.elementAt(i);
            this.arrMimeHeaders.addElement(new MimeHeader(f, this.tagName + String.valueOf(i), this.boundary));
        }
    }

    private String generateBoundary() {
        int length = 10;
        String aleph = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random r = new Random();
        String randChars = "";
        for (int i = 0; i < length; ++i) {
            int c = r.nextInt(aleph.length());
            randChars = randChars + aleph.substring(c, c + 1);
        }
        String a_boundary = "--JUPLOAD--BOUNDARY--" + randChars + "--JUPLOAD-BOUNDARY--";
        return a_boundary;
    }

    private boolean iterateFiles() {
        int fileNumber = 0;
        int totalFiles = this.arrMimeHeaders.size();
        this.stopped = false;
        Iterator iter = this.arrMimeHeaders.iterator();
        while (iter.hasNext()) {
            block19: {
                MimeHeader mimeheader;
                block18: {
                    block17: {
                        ++fileNumber;
                        if (!this.standalone) {
                            this.myStatus.setMessage(Messages.getString("HTTPPostRequest.145") + fileNumber + "/" + totalFiles);
                        }
                        mimeheader = (MimeHeader)iter.next();
                        try {
                            this.getOutputStream().write(mimeheader.getHeader().getBytes());
                            this.getOutputStream().flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (this.standalone) break block17;
                            JUpload.getInstance().errorMessage(Messages.getString("HTTPPostRequest.1") + e.getMessage());
                        }
                    }
                    try {
                        String errorMessage = this.sendFileData(mimeheader);
                        if (this.stopped) {
                            return false;
                        }
                        if (errorMessage != null) {
                            mimeheader.getFile().setFailure(true);
                            this.showErrorMessage(errorMessage);
                            return false;
                        }
                        this.getOutputStream().flush();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        if (this.standalone) break block18;
                        JUpload.getInstance().errorMessage(Messages.getString("HTTPPostRequest.2") + e1.getMessage());
                    }
                }
                if (!this.standalone) {
                    mimeheader.getFile().setUploaded(true);
                    this.parent.getQueueSelectedFiles().notifyListenersChanged();
                }
                if (iter.hasNext()) {
                    try {
                        this.getOutputStream().write(mimeheader.getFooter().getBytes());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        if (!this.standalone) {
                            JUpload.getInstance().errorMessage(Messages.getString("HTTPPostRequest.3") + e2.getMessage());
                        }
                        break block19;
                    }
                }
                try {
                    this.getOutputStream().write(mimeheader.getLastFooter().getBytes());
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    if (this.standalone) break block19;
                    JUpload.getInstance().errorMessage(Messages.getString("HTTPPostRequest.4") + e2.getMessage());
                }
            }
            try {
                this.getOutputStream().flush();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                if (this.standalone) continue;
                JUpload.getInstance().errorMessage(Messages.getString("HTTPPostRequest.5") + e2.getMessage());
            }
        }
        return true;
    }

    private String sendFileData(MimeHeader mimeheader) throws IOException {
        if (!this.standalone) {
            if (mimeheader.getFile().isVirtual()) {
                this.myStatus.setFilename(mimeheader.getFile().getVirtualFilename());
            } else {
                this.myStatus.setFilename(mimeheader.getFile().getName());
            }
        }
        this.getOutputStream().flush();
        InputStream fin = null;
        try {
            if (mimeheader.getFile().isVirtual()) {
                byte[] data = mimeheader.getFile().getVirtualData();
                fin = new ByteArrayInputStream(data);
            } else {
                fin = new FileInputStream(mimeheader.getFile());
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return Messages.getString("HTTPPostRequest.errormessage.filenotfound") + mimeheader.getFile();
        }
        byte[] buffer = new byte[16384];
        try {
            long fileSize = mimeheader.getContentLength();
            this.counter = 0L;
            while (fin.available() > 0 && !this.stopped) {
                int c = fin.read(buffer);
                try {
                    this.getOutputStream().write(buffer, 0, c);
                    this.getOutputStream().flush();
                }
                catch (SocketException se) {
                    se.printStackTrace();
                    return Messages.getString("HTTPPostRequest.errormessage.serverdisconnected") + se.getLocalizedMessage();
                }
                this.counter += (long)c;
                this.totalBytesSent += (long)c;
                if (this.standalone) continue;
                this.myStatus.setValue(this.counter, fileSize);
                this.myStatus.setTotalValue(this.totalBytesSent, this.contentLength);
            }
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void sendHeader() throws IOException {
        this.getOutputStream().write(this.m_sbHeader.toString().getBytes());
    }

    public void stopUpload() {
        this.stopped = true;
    }
}

