<?php
/**
 *	The main template file.
 *
 *	This is the most generic template file in a WordPress theme
 *	and one of the two required files for a theme (the other being style.css).
 *	It is used to display a page when nothing more specific matches a query.
 *	E.g., it puts together the home page when no home.php file exists.
 *	Learn more: https://codex.wordpress.org/Template_Hierarchy
 *
 *	@package Decode
 */

get_header(); ?>
<section id="primary" class="content-area">

	<main id="main" class="site-main" role="main">

	<?php if ( have_posts() ) : ?>

		<?php /* Start the Loop */ ?>

		<?php while ( have_posts() ) : the_post(); ?>
			<?php
				if ( get_theme_mod( 'use_excerpts', false ) == true && ! is_sticky() ) {
					get_template_part( 'content', 'excerpt' );
				}

					/* Include the Post-Format-specific template for the content.
					 * If you want to overload this in a child theme then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
				else {
					get_template_part( 'content', get_post_format() );
				}
			?>
		<?php endwhile; ?>
	<?php else : ?>
		<?php get_template_part( 'content', 'none' ); ?>
	<?php endif; ?>
		<?php decode_the_posts_navigation(); ?>
	</main><!-- #main -->

</section><!-- #primary -->

<?php get_footer(); ?>