<?php
// Require Captcha API
require("captcha_api.php");
require("twitter_oauth.php");
// Generate Google Referral Link
function GenerateGoogleRef($destination_url, $keywords, $tld){
	// Get Info
	try{
		$url = GetUpdatedPart($destination_url, "1");
	}catch(Exception $e){
		throw new Exception("Failed To Retrieve Latest URL: ".$e->getMessage());
		}
	// Load Updated URL Part
	try{
		$content = Return_Content($url);
	}catch(Exception $e){
		throw new Exception("Failed To Load Google: ".$e->getMessage());
		}
	// Scrape Area
	$url_area = get_string_between($content, "/policies/technologies/cookies/", "getElementById");
	if($url_area==""){$url_area = get_string_between($content, "Search Results", "getElementById");}
	if($url_area==""){$url_area = get_string_between($content, "Suchergebnisse", "getElementById");}
	if($url_area==""){$url_area = get_string_between($content, "var isDesktop", "#foot");}
	// Confirm Available
	if($url_area==""){
		if(strstr($content, "detected unusual traffic")){
			throw new Exception("Your Server IP Address Has Been Detected For Unusual Activity By Google");
		}else{
			LogError("GenerateGoogleRef_1", $url." - ".$content);
			throw new Exception("Failed To Parse Scrape Area From Google - Is This URL Indexed In Google?");
			}
		}
	// Scrape Variables
	$ei = get_string_between($url_area,"eid=\"","\"");
	$usg = get_string_between($url_area,"onmousedown=\"return rwt(this,'','','','1','","'");
	$ved_area = get_string_between($url_area,$usg."','",")");
	$ved = get_string_between($ved_area,"','","'");
	$found_url = get_string_between($url_area,'<a href="', '"');
	// Confirm Available
	if($ei==""||$ved==""||$usg==""){
		if(strstr($content,"no information is available")){
			throw new Exception("URL Not Available On Google");
			}
		LogError("GenerateGoogleRef_2", $content);
		throw new Exception("Failed To Scrape Required Variables From Google - Unknown Issue");
		}
	// Check URL Is The Same
	if($found_url!=$destination_url){
		throw new Exception("Destination URL Appears Differently On Google: ".$found_url);
		}
	// Set Template URL
	$scraped_url = "http://www.google".$tld."/url?sa=t&rct=j&q=".str_replace(" ","+",$keywords)."&esrc=s&source=web&cd=1&ved=".$ved."&url=".urlencode($destination_url)."&ei=".$ei."&usg=".$usg;
	// Return Link
	return $scraped_url;
	}
// Mobile Generate Twitter Referral Link
function GenerateTwitterDesktopRef($destination_url){
	global $twitter_consumer_key, $twitter_consumer_secret, $twitter_access_token, $twitter_access_token_secret;
	$connection = getConnectionWithAccessToken($twitter_consumer_key, $twitter_consumer_secret, $twitter_access_token, $twitter_access_token_secret);
	$parameters = array('status' => $destination_url);
	$content = $connection->post('statuses/update', $parameters);
	// Check For Errors
	if(isset($content->errors)){
		foreach($content->errors as $error){
			throw new Exception($error->message);
			break;
			}
		}
	// Scrape t.com URL
	$scraped_url = $content->text;
	// Confirm Available
	if(!strstr($scraped_url, "https://")){
		if(strstr($content, "automated behavior")){
			throw new Exception("Please Manually Unlock Twitter Account To Generate Link");
		}else{
			LogError("GenerateTwitterDesktopRef_4", $content->text);
			throw new Exception("Failed To Scrape t.co Link - Unknown Issue");
			}
		}
	// Return Link
	return $scraped_url;
	}
// Generate StumbleUpon Referral Link
function GenerateStumbleUponRef($destination_url){
	global $stumbleupon_username, $stumbleupon_password;
	// Load Index URL To Check If Already Indexed
	$url = "http://www.stumbleupon.com/services/1.01/badge.getinfo?url=".urlencode($destination_url);
	try{
		$content = Return_Content($url);
	}catch(Exception $e){
		throw new Exception("Failed To Load Index URL: ".$e->getMessage());
		}
	// Check If In Index
	if(strstr($content, "in_index\":true")){
		$publicid = get_string_between($content, '"publicid":"', '"');
		if($publicid!=""){
			// Return Link
			return "http://www.stumbleupon.com/su/".$publicid;
			}
		}
	// Load Login Page
	$url = "https://www.stumbleupon.com/";
	try{
		$content = Return_Content($url);
	}catch(Exception $e){
		throw new Exception("Failed To Load Signin Page: ".$e->getMessage());
		}
	// Scrape Variables
	$app_url = get_string_between($content, "\"app\":\"", "\"");
	// Confirm Available
	if($app_url==""){
		LogError("GenerateStumbleUponRef_1", $data."\r\n\r\n\r\n".$content);
		throw new Exception("Failed To Scrape Required App URL - Unknown Issue");
		}
	// Load App URL
	try{
		$content = Return_Content($app_url);
	}catch(Exception $e){
		throw new Exception("Failed To Load App URL (".$app_url."): ".$e->getMessage());
		}
	// Scrape Tokens
	$ConsumerKey = get_string_between($content, "'X-Su-ConsumerKey': '", "'");
	$SuVersion = get_string_between($content, "hash: '", "'");
	$SuClientId = CreateGuid();
	// Confirm Available
	if($ConsumerKey==""||$SuVersion==""){
		LogError("GenerateStumbleUponRef_2", $data."\r\n\r\n\r\n".$content);
		throw new Exception("Failed To Scrape Required Tokens From App URL - Unknown Issue");
		}
	// Re-Format Variables
	$SuVersion = "spa 3.1 js master_".$SuVersion." SU";	
	// Get Captcha Answer
	try{
		$captcha_answer = SolveRecaptcha("6LeqJDwUAAAAANA2VzUkSRl2e2fBZLTTLd60ey1r", "stumbleupon.com");
		// Check Available
		if($captcha_answer==""){throw new Exception("Captcha Service Returned A Blank Captcha Answer");}
	}catch(Exception $e){
		throw new Exception("Failed To Obtan Captcha Answer - ".$e->getMessage());
		}
	// Post Login Information
	$url = "https://www.stumbleupon.com/api/v2_0/auth/login";
	$data = "username=".urlencode($stumbleupon_username)."&password=".urlencode($stumbleupon_password)."&recaptcha=".$captcha_answer;
	try{
		$content = StumbleUpon_Post_Data($url,$data,"https://www.stumbleupon.com/home",$ConsumerKey,$SuVersion,$SuClientId,"");
	}catch(Exception $e){
		throw new Exception("Failed To Post Login Information: ".$e->getMessage());
		}
	// Confirm Logged In
	if((!strstr($content,'"_success":true'))&&(!strstr($content,'loggedIn":true'))){
		if(strstr($content, "Invalid username")){
			throw new Exception("Failed To Login To Account - Incorrect Login Information");	
		}else{
			LogError("GenerateStumbleUponRef_3", $data."\r\nConsumerKey:".$ConsumerKey."\r\nSuVersion:".$SuVersion."\r\nSuClientId:".$SuClientId."\r\n\r\n\r\n".$content);
			throw new Exception("Failed To Login To Account - Unknown Issue");	
			}
		}
	// Scrape Access Token (Cookies Are Automatically Added By StumbleUpon_Post_Data)
	$AccessTokenKey = get_string_between($content, "\"key\":\"", "\"");
	$SU_Remember = get_string_between($content, "\"su_remember\":\"", "\"");
	// Load P URL
	$url = "http://www.stumbleupon.com/p";
	try{
		$content = Return_Content($url);
	}catch(Exception $e){
		throw new Exception("Failed To StumbleUpon Login (P) URL: ".$e->getMessage());
		}
	// Load Submit Page
	$url = "http://www.stumbleupon.com/submit?_nospa=true&_notoolbar=true&_notoolbar=true&_nospa=true";
	try{
		$content = StumbleUpon_Return_Content($url,$AccessTokenKey,$SU_Remember);
	}catch(Exception $e){
		throw new Exception("Failed To Load Submit Page URL: ".$e->getMessage());
		}
	// Scrape Token
	$authenticity_token = get_string_between($content,"name=\"_token\" value=\"", "\"");
	if($authenticity_token==""){
		LogError("GenerateStumbleUponRef_4", $data."\r\n\r\n\r\n".$content);
		throw new Exception("Failed To Scrape Required Token - Unknown Issue");
		}
	// Get Info
	try{
		$data = GetUpdatedPart($destination_url, "3");
	}catch(Exception $e){
		throw new Exception("Failed To Retrieve Latest URL: ".$e->getMessage());
		}
	// Post Tweet
	$url = "http://www.stumbleupon.com/submit?_nospa=true&_notoolbar=true&_notoolbar=true&_nospa=true";
	$data = str_replace("{AUTH}", $authenticity_token, $data);
	try{
		$content = Post_Data($url,$data);
	}catch(Exception $e){
		throw new Exception("Failed To Post New Link: ".$e->getMessage());
		}
	// Confirm Successful
	if(!strstr($content, '"_success":true')){
		LogError("GenerateStumbleUponRef_5", $data."\r\n\r\n\r\n".$content);
		throw new Exception("Failed To Post New Link - Unknown Issue");
		}
	// Scrape ID
	$scraped_url = get_string_between($content, "\"publicid\":\"", "\"");
	// Confirm Available
	if($scraped_url==""){
		LogError("GenerateStumbleUponRef_6", $data."\r\n\r\n\r\n".$content);
		throw new Exception("Failed To Scrape Submission ID - Unknown Issue");
		}
	// Re-Format Link
	$scraped_url = "http://www.stumbleupon.com/su/".$scraped_url;
	// Return Link
	return $scraped_url;
	}
// Create GUID For StumbleUpon
function CreateGuid(){
    if (function_exists('com_create_guid') === true){
        return trim(com_create_guid(), '{}');
    	}
    return sprintf('%04X%04X-%04X-%04X-%04X-%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
	}
?>